/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import android.content.Context;
import com.newrelic.agent.android.AndroidAgentImpl;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.logging.AndroidAgentLog;
import com.newrelic.agent.android.logging.NullAgentLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Bootstrap {
    private static final String CONF_NEW_RELIC_APPLICATION_NAME = "new_relic_application_name";
    private static final String CONF_NEW_RELIC_ENABLE_LOCATION = "new_relic_enable_location";
    private static final String CONF_NEW_RELIC_ENABLE_SSL = "new_relic_enable_ssl";
    public static final String CONF_NEW_RELIC_APPLICATION_TOKEN = "new_relic_application_token";
    private static final String CONF_NEW_RELIC_COLLECTOR = "new_relic_collector";
    private static final String CONF_NEW_RELIC_ENABLE_LOGGING = "new_relic_enable_logging";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String DEFAULT_COLLECTOR_ADDR = "mobile-collector.newrelic.com";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void go(Context context) {
        try {
            InputStream in;
            try {
                in = context.getAssets().open("newrelic.properties");
            }
            catch (IOException e) {
                AgentLogManager.setAgentLog(new AndroidAgentLog());
                log.error("Could not open assets/newrelic.properties! New Relic will not start.");
                AgentLogManager.setAgentLog(new NullAgentLog());
                return;
            }
            try {
                Properties properties = new Properties();
                properties.load(in);
                boolean logging = Bootstrap.truthy(properties.getProperty(CONF_NEW_RELIC_ENABLE_LOGGING, "true"));
                if (!logging) {
                    AgentLogManager.setAgentLog(new NullAgentLog());
                } else {
                    AgentLogManager.setAgentLog(new AndroidAgentLog());
                }
                log.debug("Trying to bootstrap New Relic");
                String collectorAddr = properties.getProperty(CONF_NEW_RELIC_COLLECTOR, DEFAULT_COLLECTOR_ADDR);
                String licenseKey = properties.getProperty(CONF_NEW_RELIC_APPLICATION_TOKEN, null);
                if (licenseKey != null) {
                    log.info("License key found! Starting the New Relic agent.");
                    log.debug("Collector host is " + collectorAddr);
                    boolean ssl = Bootstrap.truthy(properties.getProperty(CONF_NEW_RELIC_ENABLE_SSL, "true"));
                    boolean location = Bootstrap.truthy(properties.getProperty(CONF_NEW_RELIC_ENABLE_LOCATION, "false"));
                    String appName = properties.getProperty(CONF_NEW_RELIC_APPLICATION_NAME, null);
                    if (ssl) {
                        log.debug("SSL enabled");
                    }
                    if (appName != null) {
                        log.debug("App name override: " + appName);
                    }
                    AndroidAgentImpl.init(context, licenseKey, collectorAddr, ssl, location, appName);
                } else {
                    log.warning("No licenase key found: New Relic will not start");
                }
            }
            finally {
                in.close();
            }
        }
        catch (Throwable e) {
            log.error("Error occurred while starting the New Relic agent!", e);
        }
    }

    private static boolean truthy(String input) {
        return "on".equals(input) || "1".equals(input) || "true".equals(input) || "yes".equals(input);
    }
}

