/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stats;

import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class StatsEngine {
    public static final StatsEngine INSTANCE = new StatsEngine();
    public boolean enabled = true;
    private ConcurrentHashMap<String, Stat> statsMap = new ConcurrentHashMap();
    private static final AgentLog log = AgentLogManager.getAgentLog();

    private StatsEngine() {
    }

    public static StatsEngine get() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inc(String name) {
        Stat s;
        Stat stat = s = this.lazyGet(name);
        synchronized (stat) {
            ++s.callCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inc(String name, long count) {
        Stat s;
        Stat stat = s = this.lazyGet(name);
        synchronized (stat) {
            s.callCount += count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordTime(String name, float time) {
        Stat s;
        Stat stat = s = this.lazyGet(name);
        synchronized (stat) {
            s.haveTime = true;
            ++s.callCount;
            s.totalTime += time;
            s.minTime = Math.min(time, s.minTime);
            s.maxTime = Math.max(time, s.maxTime);
        }
    }

    public void recordTimeMs(String name, long time) {
        this.recordTime(name, (float)time / 1000.0f);
    }

    public static void populateMetrics(JSONObject metrics) {
        for (Map.Entry<String, Stat> entry : INSTANCE.getStatsMap().entrySet()) {
            try {
                metrics.put(entry.getKey(), (Object)entry.getValue().toJSONObject());
            }
            catch (JSONException e) {
                log.warning("Unable to build metric for " + entry.getKey() + ":" + e.toString());
            }
        }
    }

    public static void reset() {
        INSTANCE.getStatsMap().clear();
    }

    public static synchronized void disable() {
        StatsEngine.INSTANCE.enabled = false;
    }

    public static synchronized void enable() {
        StatsEngine.INSTANCE.enabled = true;
    }

    private ConcurrentHashMap<String, Stat> getStatsMap() {
        return this.statsMap;
    }

    private Stat lazyGet(String name) {
        Stat s = this.statsMap.get(name);
        if (s == null) {
            s = new Stat();
            if (this.enabled) {
                this.statsMap.put(name, s);
            }
        }
        return s;
    }

    private class Stat {
        public long callCount = 0L;
        public float totalTime = 0.0f;
        public float minTime = Float.MAX_VALUE;
        public float maxTime = Float.MIN_VALUE;
        public float sumOfSquares = 0.0f;
        public boolean haveTime = false;

        private Stat() {
        }

        public synchronized JSONObject toJSONObject() throws JSONException {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("count", this.callCount);
            map.put("total", Float.valueOf(this.totalTime));
            map.put("min", Float.valueOf(this.haveTime ? this.minTime : 0.0f));
            map.put("max", Float.valueOf(this.haveTime ? this.maxTime : 0.0f));
            map.put("sum_of_squares", Float.valueOf(this.sumOfSquares));
            return new JSONObject(map);
        }
    }
}

