/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import android.os.Process;
import com.newrelic.agent.android.api.common.MachineMeasurements;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.util.MachineMeasurementsSampler;

public final class AndroidMachineMeasurementsSampler
implements MachineMeasurementsSampler {
    private static AgentLog log = AgentLogManager.getAgentLog();
    private static final int[] PID = new int[]{Process.myPid()};
    private static final int KB_IN_MB = 1024;
    private final Context context;

    public AndroidMachineMeasurementsSampler(Context context) {
        this.context = context;
    }

    public MachineMeasurements sample() {
        return new MachineMeasurements(this.getResidentMemory(this.context));
    }

    private float getResidentMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        Debug.MemoryInfo[] memInfo = activityManager.getProcessMemoryInfo(PID);
        int thisMeasurement = memInfo[0].getTotalPss();
        if (thisMeasurement >= 0) {
            return thisMeasurement / 1024;
        }
        log.debug("MemorySampler: getTotalPss() returned a negative value!");
        return 0.0f;
    }
}

