/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import android.content.SharedPreferences;
import com.newrelic.agent.android.api.common.ConnectionState;
import com.newrelic.agent.android.api.v1.DeviceInfo;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONTokener;

public final class ConnectionStateUtil {
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public static ConnectionState fromSharedPreferences(SharedPreferences prefs) {
        Object dataToken;
        String dataTokenStr = prefs.getString("dataToken", null);
        try {
            dataToken = new JSONTokener(dataTokenStr).nextValue();
        }
        catch (JSONException e) {
            dataToken = null;
            log.error("Failed to parse data token", e);
        }
        String crossProcessId = prefs.getString("crossProcessId", null);
        long serverTimestamp = prefs.getLong("serverTimestamp", 0L);
        long harvestIntervalInSeconds = prefs.getLong("harvestIntervalInSeconds", 0L);
        long maxTransactionAgeInSeconds = prefs.getLong("maxTransactionAgeInSeconds", 0L);
        long maxTransactionCount = prefs.getLong("maxTransactionCount", 0L);
        int stackTraceLimit = prefs.getInt("stackTraceLimit", 0);
        int responseBodyLimit = prefs.getInt("responseBodyLimit", 0);
        boolean collectNetworkErrors = prefs.getBoolean("collectNetworkErrors", true);
        int errorLimit = prefs.getInt("errorLimit", 10);
        return new ConnectionState(dataToken, crossProcessId, serverTimestamp, harvestIntervalInSeconds, TimeUnit.SECONDS, maxTransactionAgeInSeconds, TimeUnit.SECONDS, maxTransactionCount, stackTraceLimit, responseBodyLimit, collectNetworkErrors, errorLimit);
    }

    public static void saveSharedPreferences(SharedPreferences prefs, ConnectionState connectionState, DeviceInfo deviceInfo, String appToken) {
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("dataToken", connectionState.getDataToken().toString()).putString("agentVersion", deviceInfo.toString()).putString("crossProcessId", connectionState.getCrossProcessId()).putLong("serverTimestamp", connectionState.getServerTimestamp()).putLong("harvestIntervalInSeconds", connectionState.getHarvestIntervalInSeconds()).putLong("maxTransactionAgeInSeconds", connectionState.getMaxTransactionAgeInSeconds()).putLong("maxTransactionCount", connectionState.getMaxTransactionCount()).putInt("stackTraceLimit", connectionState.getStackTraceLimit()).putInt("responseBodyLimit", connectionState.getResponseBodyLimit()).putBoolean("collectNetworkErrors", connectionState.isCollectingNetworkErrors()).putInt("errorLimit", connectionState.getErrorLimit()).putString("appToken", appToken);
        editor.commit();
    }

    public static void clearSharedPreferences(SharedPreferences prefs) {
        SharedPreferences.Editor editor = prefs.edit();
        editor.remove("dataToken").remove("agentVersion").remove("crossProcessId").remove("serverTimestamp").remove("harvestIntervalInSeconds").remove("maxTransactionAgeInSeconds").remove("maxTransactionCount").remove("stackTraceLimit").remove("responseBodyLimit").remove("collectNetworkErrors").remove("errorLimit").remove("appToken");
        editor.commit();
    }

    public static boolean isValid(ConnectionState connectionState) {
        return connectionState.getDataToken() != null && !ConnectionStateUtil.isBlank(connectionState.getCrossProcessId());
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private ConnectionStateUtil() {
    }
}

