/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Address;
import android.location.Geocoder;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.AgentInitializationException;
import com.newrelic.agent.android.NullAgentImpl;
import com.newrelic.agent.android.api.common.ConnectionState;
import com.newrelic.agent.android.api.common.ErrorData;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.api.v1.Configuration;
import com.newrelic.agent.android.api.v1.ConnectionEvent;
import com.newrelic.agent.android.api.v1.ConnectionListener;
import com.newrelic.agent.android.api.v1.DefaultNewRelicApi;
import com.newrelic.agent.android.api.v1.DeviceForm;
import com.newrelic.agent.android.api.v1.NewRelicApi;
import com.newrelic.agent.android.background.ApplicationStateEvent;
import com.newrelic.agent.android.background.ApplicationStateListener;
import com.newrelic.agent.android.background.ApplicationStateMonitor;
import com.newrelic.agent.android.background.HarvestHeartbeat;
import com.newrelic.agent.android.instrumentation.Location;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.util.AndroidConnectivitySampler;
import com.newrelic.agent.android.util.AndroidEncoder;
import com.newrelic.agent.android.util.AndroidMachineMeasurementsSampler;
import com.newrelic.agent.android.util.Carrier;
import com.newrelic.agent.android.util.ConnectionStateUtil;
import com.newrelic.agent.android.util.ConnectivitySampler;
import com.newrelic.agent.android.util.Encoder;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidAgentImpl
implements AgentImpl,
ConnectionListener,
ApplicationStateListener {
    public static final String PREF_MAX_TRANSACTION_COUNT = "maxTransactionCount";
    public static final String PREF_MAX_TRANSACTION_AGE = "maxTransactionAgeInSeconds";
    public static final String PREF_HARVEST_INTERVAL = "harvestIntervalInSeconds";
    public static final String PREF_SERVER_TIMESTAMP = "serverTimestamp";
    public static final String PREF_CROSS_PROCESS_ID = "crossProcessId";
    public static final String PREF_AGENT_VERSION = "agentVersion";
    public static final String PREF_DATA_TOKEN = "dataToken";
    public static final String PREF_APP_TOKEN = "appToken";
    public static final String PREF_ANDROID_ID_BUG_WORK_AROUND = "androidIdBugWorkAround";
    public static final String PREF_STACK_TRACE_LIMIT = "stackTraceLimit";
    public static final String PREF_RESPONSE_BODY_LIMIT = "responseBodyLimit";
    public static final String PREF_COLLECT_NETWORK_ERRORS = "collectNetworkErrors";
    public static final String PREF_ERROR_LIMIT = "errorLimit";
    static final String NEW_RELIC_AGENT_DISABLED_VERSION_KEY = "NewRelicAgentDisabledVersion";
    private static final float LOCATION_ACCURACY_THRESHOLD = 500.0f;
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final HarvestHeartbeat heartbeat;
    private final Context context;
    private final ArrayList<TransactionData> transactionDataList;
    private final ArrayList<ErrorData> errorDataList;
    private final NewRelicApi api;
    private final String packageName;
    private ConnectionState connectionState = ConnectionState.NULL;
    private LocationListener locationListener;
    private final Lock lock = new ReentrantLock();
    private boolean connected = false;
    private final Condition connectedCond = this.lock.newCondition();
    private final Encoder encoder = new AndroidEncoder();
    private final String appToken;
    private static final Comparator<TransactionData> cmp = new Comparator<TransactionData>(){

        @Override
        public int compare(TransactionData lhs, TransactionData rhs) {
            if (lhs.getTimestamp() > rhs.getTimestamp()) {
                return -1;
            }
            if (lhs.getTimestamp() < rhs.getTimestamp()) {
                return 1;
            }
            return 0;
        }
    };

    public AndroidAgentImpl(Context context, String licenseKey, String collectorAddr, boolean ssl, boolean locationEnabled, String appName) throws AgentInitializationException {
        this.context = AndroidAgentImpl.appContext(context);
        if (this.isDisabled()) {
            throw new AgentInitializationException("This version of the agent has been disabled");
        }
        this.transactionDataList = new ArrayList();
        this.errorDataList = new ArrayList();
        AppInfo appInfo = AppInfo.fromContext(this.context);
        this.packageName = appInfo.getPackageName();
        if (locationEnabled && appInfo.getPackageManager().checkPermission("android.permission.ACCESS_FINE_LOCATION", this.packageName) == 0) {
            log.debug("Location stats enabled");
            this.addLocationListener();
        }
        String deviceId = this.getUUID();
        Configuration config = new Configuration();
        config.setAppName(appName == null ? appInfo.getAppName() : appName);
        config.setAppVersion(appInfo.getAppVersion());
        config.setPackageId(appInfo.getPackageName());
        config.setLicenseKey(licenseKey);
        config.setDeviceId(deviceId);
        config.setDeviceForm(AndroidAgentImpl.deviceForm(context));
        config.setCollectorHost(collectorAddr);
        config.setSslEnabled(ssl);
        config.setDeviceManufacturer(Build.MANUFACTURER);
        config.setDeviceModel(Build.MODEL);
        config.setAndroidRelease(Build.VERSION.RELEASE);
        if (!config.validate()) {
            throw new AgentInitializationException("Failed to validate agent configuration");
        }
        this.appToken = licenseKey;
        DefaultNewRelicApi defaultNewRelicApi = new DefaultNewRelicApi(config);
        defaultNewRelicApi.addConnectionListener(this);
        this.api = defaultNewRelicApi;
        this.heartbeat = this.createHarvestHeartbeat(60L, TimeUnit.SECONDS, 50L, TimeUnit.SECONDS, new AndroidConnectivitySampler(context));
        ApplicationStateMonitor.getInstance().addApplicationStateListener(this);
    }

    AndroidAgentImpl(Context context, String appToken, String collectorAddr, boolean ssl, boolean locationEnabled, NewRelicApi api, ConnectivitySampler connectivitySampler, long harvestInterval, TimeUnit harvestUnit, long minDelta, TimeUnit minDeltaUnit) throws AgentInitializationException {
        this.context = AndroidAgentImpl.appContext(context);
        if (this.isDisabled()) {
            throw new AgentInitializationException("This version of the agent has been disabled");
        }
        this.transactionDataList = new ArrayList();
        this.errorDataList = new ArrayList();
        AppInfo appInfo = AppInfo.fromContext(this.context);
        this.packageName = appInfo.getPackageName();
        if (locationEnabled && appInfo.getPackageManager().checkPermission("android.permission.ACCESS_FINE_LOCATION", this.packageName) == 0) {
            log.debug("Location stats enabled");
            this.addLocationListener();
        }
        this.appToken = appToken;
        this.api = api;
        this.heartbeat = this.createHarvestHeartbeat(harvestInterval, harvestUnit, minDelta, minDeltaUnit, connectivitySampler);
        ApplicationStateMonitor.getInstance().addApplicationStateListener(this);
    }

    private HarvestHeartbeat createHarvestHeartbeat(long harvestInterval, TimeUnit harvestUnit, long minDelta, TimeUnit minDeltaUnit, ConnectivitySampler connectivitySampler) {
        return new HarvestHeartbeat(this.api, new AndroidMachineMeasurementsSampler(this.context), connectivitySampler, harvestInterval, harvestUnit, minDelta, minDeltaUnit);
    }

    private static DeviceForm deviceForm(Context context) {
        int deviceSize = context.getResources().getConfiguration().screenLayout & 0xF;
        switch (deviceSize) {
            case 1: {
                return DeviceForm.SMALL;
            }
            case 2: {
                return DeviceForm.NORMAL;
            }
            case 3: {
                return DeviceForm.LARGE;
            }
        }
        if (deviceSize > 3) {
            return DeviceForm.XLARGE;
        }
        return DeviceForm.UNKNOWN;
    }

    private static Context appContext(Context context) {
        if (!(context instanceof Application)) {
            return context.getApplicationContext();
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactionData(TransactionData transactionData) {
        long maxTransactionCount;
        if (transactionData != null && this.isStaleTransaction(transactionData) || !this.isConnected()) {
            return;
        }
        this.lock.lock();
        try {
            maxTransactionCount = this.connectionState.getMaxTransactionCount();
        }
        finally {
            this.lock.unlock();
        }
        ArrayList<TransactionData> arrayList = this.transactionDataList;
        synchronized (arrayList) {
            boolean needConstraint = this.isTransactionListFull(maxTransactionCount);
            this.transactionDataList.add(transactionData);
            if (needConstraint) {
                this.constrainTransactions(maxTransactionCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeTransactionData(List<TransactionData> transactionDataList) {
        if (!this.isConnected()) {
            return;
        }
        this.purgeStaleTransactions(transactionDataList);
        if (transactionDataList.size() > 0) {
            this.lock.lock();
            long maxTransactionCount = this.connectionState.getMaxTransactionCount();
            this.lock.unlock();
            ArrayList<TransactionData> arrayList = this.transactionDataList;
            synchronized (arrayList) {
                this.transactionDataList.addAll(transactionDataList);
                this.constrainTransactions(maxTransactionCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TransactionData> getAndClearTransactionData() {
        ArrayList<TransactionData> arrayList = this.transactionDataList;
        synchronized (arrayList) {
            ArrayList<TransactionData> result = new ArrayList<TransactionData>(this.transactionDataList);
            this.transactionDataList.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addErrorData(ErrorData errorData) {
        long maxErrorCount;
        this.lock.lock();
        try {
            if (!this.connectionState.isCollectingNetworkErrors()) {
                return;
            }
            maxErrorCount = this.connectionState.getErrorLimit();
        }
        finally {
            this.lock.unlock();
        }
        ArrayList<ErrorData> arrayList = this.errorDataList;
        synchronized (arrayList) {
            for (ErrorData error : this.errorDataList) {
                if (!errorData.getHash().equals(error.getHash())) continue;
                error.incrementCount();
                return;
            }
            if (!this.isErrorListFull(maxErrorCount)) {
                this.errorDataList.add(errorData);
            } else {
                log.warning("Error limit (" + maxErrorCount + ") exceeded for this harvest! Skipping new error.");
                StatsEngine.get().inc("Supportability/MobileAgent/ErrorsDropped");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ErrorData> getAndClearErrorData() {
        ArrayList<ErrorData> arrayList = this.errorDataList;
        synchronized (arrayList) {
            ArrayList<ErrorData> result = new ArrayList<ErrorData>(this.errorDataList);
            this.errorDataList.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeErrorData(List<ErrorData> errorDataList) {
        long maxErrorCount;
        this.lock.lock();
        try {
            if (!this.connectionState.isCollectingNetworkErrors()) {
                return;
            }
            maxErrorCount = this.connectionState.getErrorLimit();
        }
        finally {
            this.lock.unlock();
        }
        ArrayList<ErrorData> arrayList = this.errorDataList;
        synchronized (arrayList) {
            int slots = (int)maxErrorCount - this.errorDataList.size();
            if (slots > 0) {
                Iterator<ErrorData> it = errorDataList.iterator();
                for (int i = 0; i < slots && it.hasNext(); ++i) {
                    this.errorDataList.add(it.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCrossProcessId() {
        this.lock.lock();
        try {
            String crossProcessId = "".equals(this.connectionState.getCrossProcessId()) ? null : this.connectionState.getCrossProcessId();
            boolean connected = this.connected;
            String string2 = connected ? crossProcessId : null;
            return string2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStackTraceLimit() {
        this.lock.lock();
        try {
            int stackTraceLimit;
            int n = stackTraceLimit = this.connectionState.getStackTraceLimit();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResponseBodyLimit() {
        this.lock.lock();
        try {
            int responseBodyLimit;
            int n = responseBodyLimit = this.connectionState.getResponseBodyLimit();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void start() {
        if (!this.isDisabled()) {
            this.api.reset();
            this.heartbeat.start(!this.loadConnectionState(this.api));
        } else {
            this.stop(false);
        }
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    private void stop(boolean finalSendData) {
        this.heartbeat.stop(finalSendData);
    }

    void dispose() {
        this.heartbeat.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        log.warning("PERMANENTLY DISABLING AGENT v" + Agent.getVersion());
        try {
            SharedPreferences prefs = this.context.getSharedPreferences(AndroidAgentImpl.getPreferenceFileName(this.context.getPackageName()), 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(NEW_RELIC_AGENT_DISABLED_VERSION_KEY, Agent.getVersion());
            editor.commit();
        }
        finally {
            try {
                this.stop(false);
            }
            finally {
                Agent.setImpl(NullAgentImpl.instance);
            }
        }
    }

    @Override
    public boolean isDisabled() {
        SharedPreferences prefs = this.context.getSharedPreferences(AndroidAgentImpl.getPreferenceFileName(this.context.getPackageName()), 0);
        return Agent.getVersion().equals(prefs.getString(NEW_RELIC_AGENT_DISABLED_VERSION_KEY, null));
    }

    static void clearPreferences(Context context) {
        log.verbose("Clearing shared preferences in " + AndroidAgentImpl.getPreferenceFileName(context.getPackageName()));
        SharedPreferences prefs = context.getSharedPreferences(AndroidAgentImpl.getPreferenceFileName(context.getPackageName()), 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        editor.commit();
    }

    @Override
    public String getNetworkCarrier() {
        return Carrier.nameFromContext(this.context);
    }

    public static void init(Context context, String licenseKey, String collectorAddr, boolean ssl, boolean location, String appName) {
        try {
            Agent.setImpl(new AndroidAgentImpl(context, licenseKey, collectorAddr, ssl, location, appName));
            Agent.start();
        }
        catch (AgentInitializationException e) {
            log.error("Failed to initialize the agent: " + e.toString());
            return;
        }
    }

    public static void init(Context context, String licenseKey, String collectorAddr, boolean ssl, boolean location) {
        AndroidAgentImpl.init(context, licenseKey, collectorAddr, ssl, location, null);
    }

    @Override
    public void connected(ConnectionEvent e) {
        log.verbose("New connection detected: updating shared preferences");
        SharedPreferences prefs = this.getSharedPreferences();
        ConnectionState connectionState = e.getConnectionState();
        ConnectionStateUtil.saveSharedPreferences(prefs, connectionState, this.api.getDeviceInfo(), this.appToken);
        this.setConnectionState(connectionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected(ConnectionEvent e) {
        log.verbose("Detected disconnect: clearing shared preferences");
        SharedPreferences prefs = this.getSharedPreferences();
        ConnectionStateUtil.clearSharedPreferences(prefs);
        this.lock.lock();
        try {
            this.connectionState = ConnectionState.NULL;
            ArrayList<Object> arrayList = this.transactionDataList;
            synchronized (arrayList) {
                this.transactionDataList.clear();
            }
            arrayList = this.errorDataList;
            synchronized (arrayList) {
                this.errorDataList.clear();
            }
            this.connected = false;
            this.connectedCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void applicationForegrounded(ApplicationStateEvent e) {
        this.start();
    }

    @Override
    public void applicationBackgrounded(ApplicationStateEvent e) {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTransactionListFull(long maxTransactionCount) {
        ArrayList<TransactionData> arrayList = this.transactionDataList;
        synchronized (arrayList) {
            return (long)this.transactionDataList.size() >= maxTransactionCount;
        }
    }

    @Override
    public void setLocation(String countryCode, String adminRegion) {
        if (countryCode == null || adminRegion == null) {
            throw new IllegalArgumentException("Country code and administrative region are required.");
        }
        this.api.setLocation(new Location(countryCode, adminRegion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForConnect(long time, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            Date end = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(time, unit));
            while (!this.connected) {
                if (this.connectedCond.awaitUntil(end)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean waitForHarvest(long time, TimeUnit unit) throws InterruptedException {
        return this.heartbeat.waitForHarvest(time, unit);
    }

    public boolean waitForStop(long time, TimeUnit unit) throws InterruptedException {
        return this.heartbeat.waitForStop(time, unit);
    }

    public void setLocation(android.location.Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        Geocoder coder = new Geocoder(this.context);
        List addresses = null;
        try {
            addresses = coder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
        }
        catch (IOException e) {
            log.error("Unable to geocode location: " + e.toString());
        }
        if (addresses == null || addresses.size() == 0) {
            return;
        }
        Address address = (Address)addresses.get(0);
        if (address == null) {
            return;
        }
        String countryCode = address.getCountryCode();
        String adminArea = address.getAdminArea();
        if (countryCode != null && adminArea != null) {
            this.setLocation(countryCode, adminArea);
            this.removeLocationListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxTransactionAgeInSeconds() {
        this.lock.lock();
        try {
            long l = this.connectionState.getMaxTransactionAgeInSeconds();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void constrainTransactions(long maxTransactionCount) {
        if ((long)this.transactionDataList.size() > maxTransactionCount) {
            log.warning("Transaction count limit (" + maxTransactionCount + ") exceeded! Purging " + ((long)this.transactionDataList.size() - maxTransactionCount) + " oldest transactions");
            StatsEngine.get().inc("Supportability/MobileAgent/TransactionsDropped", (long)this.transactionDataList.size() - maxTransactionCount);
            Collections.sort(this.transactionDataList, cmp);
            while ((long)this.transactionDataList.size() > maxTransactionCount) {
                this.transactionDataList.remove(this.transactionDataList.size() - 1);
            }
        }
    }

    private boolean isErrorListFull(long maxErrorCount) {
        return (long)this.errorDataList.size() >= maxErrorCount;
    }

    private boolean loadConnectionState(NewRelicApi api) {
        SharedPreferences prefs = this.getSharedPreferences();
        log.verbose(MessageFormat.format("New Relic Agent v{0}", Agent.getVersion()));
        String lastRunVersion = prefs.getString(PREF_AGENT_VERSION, null);
        if (!this.api.getDeviceInfo().toString().equals(lastRunVersion)) {
            if (lastRunVersion != null) {
                log.verbose("New agent version detected! We'll need to reconnect.");
            }
            this.disconnected(new ConnectionEvent(this));
            return false;
        }
        String lastAppToken = prefs.getString(PREF_APP_TOKEN, null);
        if (!this.appToken.equals(lastAppToken)) {
            log.verbose("App token has changed!  We'll need to reconnect.");
            this.disconnected(new ConnectionEvent(this));
            return false;
        }
        ConnectionState connectionState = ConnectionStateUtil.fromSharedPreferences(prefs);
        if (ConnectionStateUtil.isValid(connectionState)) {
            api.setConnectionState(connectionState);
            this.setConnectionState(connectionState);
            return true;
        }
        log.warning("Invalid connection state in shared preferences: " + connectionState);
        this.disconnected(new ConnectionEvent(this));
        return false;
    }

    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences(AndroidAgentImpl.getPreferenceFileName(this.context.getPackageName()), 0);
    }

    static String getPreferenceFileName(String packageName) {
        return "com.newrelic.android.agent.v1_" + packageName;
    }

    private boolean isStaleTransaction(TransactionData transactionData) {
        long maxTransactionAge = TimeUnit.MILLISECONDS.convert(this.getMaxTransactionAgeInSeconds(), TimeUnit.SECONDS);
        return System.currentTimeMillis() - transactionData.getTimestamp() > maxTransactionAge;
    }

    private void purgeStaleTransactions(List<TransactionData> transactionDataList) {
        long maxTransactionAgeInSeconds = this.getMaxTransactionAgeInSeconds();
        long now = System.currentTimeMillis();
        Iterator<TransactionData> iter = transactionDataList.iterator();
        while (iter.hasNext()) {
            TransactionData transactionData = iter.next();
            if (now - transactionData.getTimestamp() <= TimeUnit.MILLISECONDS.convert(maxTransactionAgeInSeconds, TimeUnit.SECONDS)) continue;
            log.verbose("Purging expired transaction");
            iter.remove();
        }
    }

    private void addLocationListener() {
        LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
        if (locationManager == null) {
            log.error("Unable to retrieve reference to LocationManager. Disabling location listener.");
            return;
        }
        this.locationListener = new LocationListener(){

            public void onLocationChanged(android.location.Location location) {
                if (AndroidAgentImpl.this.isAccurate(location)) {
                    AndroidAgentImpl.this.setLocation(location);
                }
            }

            public void onProviderDisabled(String provider) {
                if (provider == "passive") {
                    AndroidAgentImpl.this.removeLocationListener();
                }
            }

            public void onProviderEnabled(String provider) {
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }
        };
        locationManager.requestLocationUpdates("passive", 1000L, 0.0f, this.locationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLocationListener() {
        if (this.locationListener == null) {
            return;
        }
        LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
        if (locationManager == null) {
            log.error("Unable to retrieve reference to LocationManager. Can't unregister location listener.");
            return;
        }
        LocationManager locationManager2 = locationManager;
        synchronized (locationManager2) {
            locationManager.removeUpdates(this.locationListener);
            this.locationListener = null;
        }
    }

    private boolean isAccurate(android.location.Location location) {
        if (location == null) {
            return false;
        }
        return 500.0f >= location.getAccuracy();
    }

    private String getUUID() {
        SharedPreferences prefs = this.getSharedPreferences();
        String uuid = prefs.getString(PREF_ANDROID_ID_BUG_WORK_AROUND, null);
        if (uuid == null) {
            SharedPreferences.Editor editor = prefs.edit();
            uuid = UUID.randomUUID().toString();
            editor.putString(PREF_ANDROID_ID_BUG_WORK_AROUND, uuid);
            editor.commit();
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnected() {
        this.lock.lock();
        try {
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnectionState(ConnectionState connectionState) {
        if (ConnectionStateUtil.isValid(connectionState)) {
            this.lock.lock();
            try {
                this.connectionState = connectionState;
            }
            finally {
                this.lock.unlock();
            }
            this.heartbeat.setInterval(connectionState.getHarvestIntervalInMilliseconds(), TimeUnit.MILLISECONDS);
            this.lock.lock();
            try {
                this.connected = true;
                this.connectedCond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        log.warning("Invalid connection state detected: " + connectionState.toString());
        this.lock.lock();
        try {
            this.connected = false;
            this.connectedCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }

    private static final class AppInfo {
        private final String packageName;
        private final String appName;
        private final String appVersion;
        private final PackageManager packageManager;

        public static AppInfo fromContext(Context context) throws AgentInitializationException {
            String appName;
            String appVersion;
            String packageName = context.getPackageName();
            PackageManager packageManager = context.getPackageManager();
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
                if (packageInfo == null) {
                    throw new AgentInitializationException("No package info available for this app");
                }
                appVersion = packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new AgentInitializationException("Could not determine package version", e);
            }
            try {
                ApplicationInfo appInfo = packageManager.getApplicationInfo(packageName, 0);
                appName = appInfo != null ? ((Object)packageManager.getApplicationLabel(appInfo)).toString() : packageName;
            }
            catch (PackageManager.NameNotFoundException e) {
                log.warning(e.toString());
                appName = packageName;
            }
            catch (SecurityException e) {
                log.warning(e.toString());
                appName = packageName;
            }
            return new AppInfo(packageName, appName, appVersion, packageManager);
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public PackageManager getPackageManager() {
            return this.packageManager;
        }

        private AppInfo(String packageName, String appName, String appVersion, PackageManager packageManager) {
            this.packageName = packageName;
            this.appName = appName;
            this.appVersion = appVersion;
            this.packageManager = packageManager;
        }
    }
}

