/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.api.v1;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.api.common.ConnectionState;
import com.newrelic.agent.android.api.common.ErrorData;
import com.newrelic.agent.android.api.common.MachineMeasurements;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.api.v1.Configuration;
import com.newrelic.agent.android.api.v1.ConnectionEvent;
import com.newrelic.agent.android.api.v1.ConnectionListener;
import com.newrelic.agent.android.api.v1.DeviceForm;
import com.newrelic.agent.android.api.v1.DeviceInfo;
import com.newrelic.agent.android.api.v1.NewRelicApi;
import com.newrelic.agent.android.api.v1.SimpleDeviceInfo;
import com.newrelic.agent.android.instrumentation.Location;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stats.TicToc;
import com.newrelic.agent.android.transport.DisableAgentException;
import com.newrelic.agent.android.transport.DisconnectAgentException;
import com.newrelic.agent.android.transport.FlushTransactionDataException;
import com.newrelic.agent.android.transport.Transport;
import com.newrelic.agent.android.transport.TransportException;
import com.newrelic.agent.android.transport.TransportFactory;
import com.newrelic.agent.android.transport.http.HttpJsonTransportFactory;
import java.io.InterruptedIOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultNewRelicApi
implements NewRelicApi {
    private static final String SESSION_DURATION_METRIC = "Session/Duration";
    private static final String AGENT_NAME = "AndroidAgent";
    private static final String OS_NAME = "Android";
    private static final String CPU_TOTAL_UTILIZATION_METRIC = "CPU/Total/Utilization";
    private static final String CPU_SYSTEM_UTILIZATION_METRIC = "CPU/System/Utilization";
    private static final String CPU_USER_UTILIZATION_METRIC = "CPU/User/Utilization";
    private static final String MEMORY_USED_METRIC = "Memory/Used";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final String appName;
    private final String appVersion;
    private final String packageId;
    private final TransportFactory transportFactory;
    private ConnectionState connectionState = ConnectionState.NULL;
    private ArrayList<ConnectionListener> connectionListeners = new ArrayList();
    private Location location;
    private SimpleDeviceInfo deviceInfo;

    public DefaultNewRelicApi(Configuration config) {
        this(config.getAppName(), config.getAppVersion(), config.getPackageId(), new HttpJsonTransportFactory(DefaultNewRelicApi.getCollectorUrl(config), config.getLicenseKey()), config.getDeviceId(), config.getDeviceForm(), config.getDeviceManufacturer(), config.getDeviceModel(), config.getAndroidRelease());
    }

    public DefaultNewRelicApi(String appName, String appVersion, String packageId, TransportFactory transportFactory, String deviceId, DeviceForm deviceForm, String deviceManufacturer, String deviceModel, String androidRelease) {
        this.appName = appName;
        this.appVersion = appVersion;
        this.packageId = packageId;
        this.transportFactory = transportFactory;
        HashMap<String, String> misc = new HashMap<String, String>();
        if (deviceForm != null) {
            misc.put("size", deviceForm.name().toLowerCase());
        }
        this.deviceInfo = new SimpleDeviceInfo(OS_NAME, androidRelease, deviceManufacturer, deviceModel, AGENT_NAME, Agent.getVersion(), deviceId, misc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        DefaultNewRelicApi defaultNewRelicApi = this;
        synchronized (defaultNewRelicApi) {
            this.connectionState = ConnectionState.NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        ArrayList<ConnectionListener> arrayList = this.connectionListeners;
        synchronized (arrayList) {
            this.connectionListeners.add(connectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener connectionListener) {
        ArrayList<ConnectionListener> arrayList = this.connectionListeners;
        synchronized (arrayList) {
            this.connectionListeners.remove(connectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectionState(ConnectionState connectionState) {
        DefaultNewRelicApi defaultNewRelicApi = this;
        synchronized (defaultNewRelicApi) {
            this.connectionState = connectionState;
        }
    }

    @Override
    public void sendConnect() throws InterruptedIOException, TransportException {
        this.connect(this.transportFactory.newTransport());
    }

    @Override
    public void sendData(double duration, Collection<TransactionData> transactionData, Collection<ErrorData> errorData, MachineMeasurements machineMeasurements) throws InterruptedIOException, TransportException {
        this.sendDataInternal(duration, transactionData, errorData, machineMeasurements, 0.0, false);
    }

    @Override
    public void sendData(double duration, Collection<TransactionData> transactionData, Collection<ErrorData> errorData, MachineMeasurements machineMeasurements, double sessionTime) throws InterruptedIOException, TransportException {
        this.sendDataInternal(duration, transactionData, errorData, machineMeasurements, sessionTime, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocation(Location location) {
        DefaultNewRelicApi defaultNewRelicApi = this;
        synchronized (defaultNewRelicApi) {
            this.location = location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionState getConnectionState() {
        DefaultNewRelicApi defaultNewRelicApi = this;
        synchronized (defaultNewRelicApi) {
            return this.connectionState;
        }
    }

    private void sendDataInternal(double duration, Collection<TransactionData> transactionData, Collection<ErrorData> errorData, MachineMeasurements machineMeasurements, double sessionTime, boolean lastRequest) throws InterruptedIOException, TransportException {
        Transport transport = this.transportFactory.newTransport();
        try {
            if (!this.isConnected()) {
                this.connect(transport);
            }
            try {
                this.data(transport, transactionData, errorData, machineMeasurements, sessionTime, lastRequest);
            }
            catch (DisconnectAgentException e) {
                log.info("The collector has asked the agent to disconnect while sending metric data");
                this.disconnect(false);
                this.connect(transport);
                this.data(transport, transactionData, errorData, machineMeasurements, sessionTime, lastRequest);
            }
        }
        catch (DisableAgentException e) {
            log.warning("The collector has asked the agent to disable itself");
            this.disconnect(true);
        }
        catch (DisconnectAgentException e) {
            log.warning("The collector has asked the agent to disconnect");
            this.disconnect(false);
        }
        catch (FlushTransactionDataException e) {
            log.warning("Flushing transaction data (transaction too big?): " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        DefaultNewRelicApi defaultNewRelicApi = this;
        synchronized (defaultNewRelicApi) {
            return this.connectionState != ConnectionState.NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(boolean disable) {
        DefaultNewRelicApi defaultNewRelicApi = this;
        synchronized (defaultNewRelicApi) {
            if (this.isConnected()) {
                try {
                    this.notifyDisconnected();
                }
                finally {
                    this.reset();
                    if (disable) {
                        Agent.disable();
                    }
                }
            }
        }
    }

    Object getDataToken() {
        return this.connectionState.getDataToken();
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    private static String getCollectorUrl(Configuration config) {
        return MessageFormat.format("{0}://{1}/mobile/v1", config.isSslEnabled() ? "https" : "http", config.getCollectorHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(Transport transport) throws InterruptedIOException, TransportException {
        String rawConnectResponse;
        log.info("Connect in progress");
        TicToc timer = new TicToc();
        try {
            JSONArray connectRequest = new JSONArray(Arrays.asList(this.buildAppInfoJson(), this.deviceInfoWithLocation().toJSONArray()));
            timer.tic();
            rawConnectResponse = transport.send(Transport.MessageType.CONNECT, connectRequest.toString(), 0L);
            StatsEngine.get().recordTimeMs("Supportability/MobileAgent/Collector/Connect", timer.toc());
        }
        catch (JSONException e) {
            throw new TransportException(e);
        }
        DefaultNewRelicApi defaultNewRelicApi = this;
        synchronized (defaultNewRelicApi) {
            int stackTraceLimit;
            int responseBodyLimit;
            int errorLimit;
            boolean collectNetworkErrors;
            long maxTransactionAgeInSeconds;
            long maxTransactionCount;
            long harvestIntervalInSeconds;
            long serverTimestamp;
            String crossProcessId;
            Object dataToken;
            try {
                JSONObject connectResponse = new JSONObject(rawConnectResponse);
                dataToken = connectResponse.get("data_token");
                crossProcessId = connectResponse.getString("cross_process_id");
                serverTimestamp = connectResponse.getLong("server_timestamp");
                harvestIntervalInSeconds = connectResponse.getLong("data_report_period");
                maxTransactionCount = connectResponse.getLong("report_max_transaction_count");
                maxTransactionAgeInSeconds = connectResponse.getLong("report_max_transaction_age");
                collectNetworkErrors = connectResponse.getBoolean("collect_network_errors");
                errorLimit = connectResponse.getInt("error_limit");
                responseBodyLimit = connectResponse.getInt("response_body_limit");
                stackTraceLimit = connectResponse.getInt("stack_trace_limit");
            }
            catch (JSONException e) {
                this.reset();
                log.error("Error while unpacking JSON response during connect");
                throw new TransportException(e);
            }
            if (dataToken == null) {
                this.reset();
                throw new TransportException("Missing or invalid data token");
            }
            if (crossProcessId == null || crossProcessId.length() == 0) {
                this.reset();
                throw new TransportException("Missing cross process ID");
            }
            if (maxTransactionCount < 0L) {
                throw new TransportException("Invalid max transaction count of " + maxTransactionCount);
            }
            if (maxTransactionAgeInSeconds <= 0L || maxTransactionAgeInSeconds > 600L) {
                maxTransactionAgeInSeconds = 600L;
            }
            if (serverTimestamp <= 0L) {
                this.reset();
                throw new TransportException("Invalid server timestamp");
            }
            if (harvestIntervalInSeconds <= 0L || harvestIntervalInSeconds > 60L) {
                harvestIntervalInSeconds = 60L;
            }
            this.setConnectionState(new ConnectionState(dataToken, crossProcessId, serverTimestamp, harvestIntervalInSeconds, TimeUnit.SECONDS, maxTransactionAgeInSeconds, TimeUnit.SECONDS, maxTransactionCount, stackTraceLimit, responseBodyLimit, collectNetworkErrors, errorLimit));
            log.verbose("Connected, notifying listeners. Got data token: " + dataToken);
            this.notifyConnected(this.getConnectionState());
        }
    }

    private void data(Transport transport, Collection<TransactionData> transactionData, Collection<ErrorData> errorData, MachineMeasurements machineMeasurements, double sessionTime, boolean lastRequest) throws InterruptedIOException, TransportException {
        JSONArray deviceInfo;
        ConnectionState connectionState = this.getConnectionState();
        if (connectionState == null) {
            log.error("Connection state is unexpectedly null! Aborting.");
            return;
        }
        JSONObject rootMetrics = new JSONObject();
        try {
            rootMetrics.put(MEMORY_USED_METRIC, (double)machineMeasurements.getMemoryUsage());
            rootMetrics.put(CPU_USER_UTILIZATION_METRIC, 0);
            rootMetrics.put(CPU_SYSTEM_UTILIZATION_METRIC, 0);
            rootMetrics.put(CPU_TOTAL_UTILIZATION_METRIC, 0);
            if (lastRequest) {
                rootMetrics.put(SESSION_DURATION_METRIC, sessionTime);
            }
            deviceInfo = this.deviceInfoWithLocation().toJSONArray();
        }
        catch (JSONException e) {
            throw new TransportException(e);
        }
        JSONArray transactionDataArray = new JSONArray();
        int numErrors = 0;
        int numFailedCalls = 0;
        for (TransactionData item : transactionData) {
            if (item.getErrorCode() != 0) {
                ++numErrors;
            } else if (item.getStatusCode() >= 400) {
                ++numFailedCalls;
            }
            transactionDataArray.put((Object)new JSONArray(item.asList()));
        }
        JSONArray errorDataArray = new JSONArray();
        for (ErrorData error : errorData) {
            errorDataArray.put((Object)new JSONArray(error.asList()));
        }
        StatsEngine.populateMetrics(rootMetrics);
        log.verbose(MessageFormat.format("Sending {0} transactions ({1} errors, {2} failed calls)", transactionDataArray.length(), numErrors, numFailedCalls));
        log.verbose(MessageFormat.format("Sending {0} error traces", errorDataArray.length()));
        JSONArray data = new JSONArray(Arrays.asList(connectionState.getDataToken(), deviceInfo, connectionState.getHarvestIntervalInSeconds(), transactionDataArray, rootMetrics, errorDataArray));
        transport.send(Transport.MessageType.DATA, data.toString(), connectionState.getServerTimestamp());
    }

    private void notifyConnected(ConnectionState connectionState) {
        ConnectionEvent e = new ConnectionEvent(this, connectionState);
        for (ConnectionListener connectionListener : this.getConnectionListeners()) {
            connectionListener.connected(e);
        }
    }

    private void notifyDisconnected() {
        ConnectionEvent e = new ConnectionEvent(this);
        for (ConnectionListener connectionListener : this.getConnectionListeners()) {
            connectionListener.disconnected(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConnectionListener> getConnectionListeners() {
        ArrayList<ConnectionListener> connectionListeners;
        ArrayList<ConnectionListener> arrayList = this.connectionListeners;
        synchronized (arrayList) {
            connectionListeners = new ArrayList<ConnectionListener>(this.connectionListeners);
        }
        return connectionListeners;
    }

    private JSONArray buildAppInfoJson() {
        return new JSONArray(Arrays.asList(this.appName, this.appVersion, this.packageId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleDeviceInfo deviceInfoWithLocation() throws JSONException {
        DefaultNewRelicApi defaultNewRelicApi = this;
        synchronized (defaultNewRelicApi) {
            if (this.location != null) {
                return this.deviceInfo.withLocation(this.location.getCountryCode(), this.location.getRegion());
            }
            return this.deviceInfo;
        }
    }
}

