/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;

public final class TransactionState {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private String url;
    private int statusCode;
    private int errorCode;
    private long bytesSent;
    private long bytesReceived;
    private long startTime = System.currentTimeMillis();
    private long endTime;
    private String appData;
    private String carrier = "unknown";
    private State state = State.READY;
    private String contentType;
    private TransactionData transactionData;

    public void setCarrier(String carrier) {
        if (!this.isSent()) {
            this.carrier = carrier;
        } else {
            log.warning("setCarrier(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setAppData(String appData) {
        if (!this.isComplete()) {
            this.appData = appData;
        } else {
            log.warning("setAppData(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setUrl(String url) {
        if (!this.isSent()) {
            this.url = url;
        } else {
            log.warning("setUrl(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSent() {
        return this.state.ordinal() >= State.SENT.ordinal();
    }

    public boolean isComplete() {
        return this.state.ordinal() >= State.COMPLETE.ordinal();
    }

    public void setStatusCode(int statusCode) {
        if (!this.isComplete()) {
            this.statusCode = statusCode;
        } else {
            log.warning("setStatusCode(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setErrorCode(int errorCode) {
        if (!this.isComplete()) {
            this.errorCode = errorCode;
        } else {
            if (this.transactionData != null) {
                this.transactionData.setErrorCode(errorCode);
            }
            log.warning("setErrorCode(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setBytesSent(long bytesSent) {
        if (!this.isComplete()) {
            this.bytesSent = bytesSent;
            this.state = State.SENT;
        } else {
            log.warning("setBytesSent(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setBytesReceived(long bytesReceived) {
        if (!this.isComplete()) {
            this.bytesReceived = bytesReceived;
        } else {
            log.warning("setBytesReceived(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public TransactionData end() {
        if (!this.isComplete()) {
            this.state = State.COMPLETE;
            this.endTime = System.currentTimeMillis();
        }
        return this.toTransactionData();
    }

    private TransactionData toTransactionData() {
        if (!this.isComplete()) {
            log.warning("toTransactionData() called on incomplete TransactionState");
        }
        if (this.url == null) {
            log.error("Attempted to convert a TransactionState instance with no URL into a TransactionData");
            return null;
        }
        if (this.transactionData == null) {
            this.transactionData = new TransactionData(this.url, this.carrier, (float)(this.endTime - this.startTime) / 1000.0f, this.statusCode, this.errorCode, this.bytesSent, this.bytesReceived, this.appData);
        }
        return this.transactionData;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    private static enum State {
        READY,
        SENT,
        COMPLETE;

    }
}

