/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.util.ConnectivitySampler;

public class AndroidConnectivitySampler
implements ConnectivitySampler {
    private static AgentLog log = AgentLogManager.getAgentLog();
    private final Context context;

    public AndroidConnectivitySampler(Context context) {
        this.context = context;
    }

    public boolean sample() {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isConnectedOrConnecting();
            }
            return false;
        }
        catch (SecurityException e) {
            log.warning("Unable to call ConnectivityManager.getActiveNetworkInfo(). Please add the android.permission.ACCESS_NETWORK_STATE permission to your AndroidManifest.xml");
            return true;
        }
    }
}

