/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.sample;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import android.os.Process;
import com.newrelic.agent.android.harvest.type.Harvestable;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.Sample;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sampler
implements TraceLifecycleAware {
    private static final int[] PID = new int[]{Process.myPid()};
    private static final int KB_IN_MB = 1024;
    private static final long MAX_SAMPLE_FREQ_MS = 100L;
    private final Context context;
    private final ActivityManager activityManager;
    private final Map<Sample.SampleType, Collection<Sample>> samples = new EnumMap<Sample.SampleType, Collection<Sample>>(Sample.SampleType.class);
    private long lastSampledAt = 0L;

    public Sampler(Context context) {
        this.context = context;
        this.activityManager = (ActivityManager)context.getSystemService("activity");
        this.samples.put(Sample.SampleType.MEMORY, new CopyOnWriteArrayList());
    }

    public void start() {
        this.clear();
        this.sample();
    }

    public void stop() {
        this.clear();
    }

    public Map<Sample.SampleType, Collection<Sample>> getAllSamples() {
        return Collections.unmodifiableMap(this.samples);
    }

    public Collection<Sample> getSamples(Harvestable.Type type) {
        return Collections.unmodifiableCollection(this.samples.get((Object)type));
    }

    public void sample() {
        long now = System.currentTimeMillis();
        if (this.lastSampledAt + 100L > now) {
            return;
        }
        Sample memorySample = this.sampleMemory();
        if (memorySample != null) {
            this.getSampleCollection(Sample.SampleType.MEMORY).add(memorySample);
        }
        this.lastSampledAt = now;
    }

    public void clear() {
        for (Collection<Sample> sampleCollection : this.samples.values()) {
            sampleCollection.clear();
        }
    }

    public Sample sampleMemory() {
        Sample sample = new Sample(Sample.SampleType.MEMORY);
        Debug.MemoryInfo[] memInfo = this.activityManager.getProcessMemoryInfo(PID);
        int totalPss = memInfo[0].getTotalPss();
        if (totalPss >= 0) {
            sample.setSampleValue((double)totalPss / 1024.0);
            return sample;
        }
        return null;
    }

    private Collection<Sample> getSampleCollection(Sample.SampleType type) {
        return this.samples.get((Object)type);
    }

    @Override
    public void onEnterMethod() {
        this.sample();
    }

    @Override
    public void onExitMethod() {
        this.sample();
    }

    @Override
    public void onTraceComplete(ActivityTrace activityTrace) {
        activityTrace.setVitals(this.getAllSamples());
    }
}

