/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.tracing;

import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.activity.NamedActivity;
import com.newrelic.agent.android.harvest.ConnectInformation;
import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.Sample;
import com.newrelic.agent.android.tracing.Trace;
import com.newrelic.agent.android.util.Util;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ActivityTrace
extends HarvestableArray {
    public static final String TRACE_VERSION = "1.0";
    public static final int MAX_TRACES = 2000;
    public Trace rootTrace;
    private ConcurrentHashMap<String, Trace> traces;
    private Set<String> missingChildren;
    private NamedActivity measuredActivity;
    private long reportAttemptCount;
    public long lastUpdatedAt;
    public long startedAt;
    private boolean complete;
    private HashMap<String, String> params;
    private Map<Sample.SampleType, Collection<Sample>> vitals;
    private AgentLog log;
    private String size = "NORMAL";
    private static final HashMap<String, String> environmentType = new HashMap<String, String>(){
        {
            this.put("type", "ENVIRONMENT");
        }
    };
    private static final HashMap<String, String> vitalsType = new HashMap<String, String>(){
        {
            this.put("type", "VITALS");
        }
    };

    public ActivityTrace() {
    }

    public ActivityTrace(Trace rootTrace) {
        this.rootTrace = rootTrace;
        this.traces = new ConcurrentHashMap();
        this.missingChildren = Util.newStringSetFromMapProxy(this.missingChildren);
        this.startedAt = this.lastUpdatedAt = rootTrace.entryTimestamp;
        this.complete = false;
        this.params = new HashMap();
        this.params.put("traceVersion", TRACE_VERSION);
        this.params.put("type", "ACTIVITY");
        this.measuredActivity = (NamedActivity)Measurements.startActivity(rootTrace.metricName);
        this.measuredActivity.setStartTime(rootTrace.entryTimestamp);
        this.measuredActivity.setBackgroundName(rootTrace.metricBackgroundName);
        this.log = AgentLogManager.getAgentLog();
        this.reportAttemptCount = 0L;
    }

    public void addTrace(Trace trace) {
        this.missingChildren.add(trace.UUID);
        this.lastUpdatedAt = System.currentTimeMillis();
    }

    public void addCompletedTrace(Trace trace) {
        trace.traceMachine = null;
        this.missingChildren.remove(trace.UUID);
        if (this.traces.size() > 2000) {
            this.log.debug("Maximum trace limit reached, discarding trace " + trace.UUID);
            return;
        }
        this.traces.put(trace.UUID, trace);
        if (trace.exitTimestamp > this.rootTrace.exitTimestamp) {
            this.rootTrace.exitTimestamp = trace.exitTimestamp;
        }
        this.log.debug("Added trace " + trace.UUID + " missing children: " + this.missingChildren.size());
        this.lastUpdatedAt = System.currentTimeMillis();
    }

    public boolean hasMissingChildren() {
        return !this.missingChildren.isEmpty();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void complete() {
        this.log.debug("Completing trace of " + this.rootTrace.displayName + ":" + this.rootTrace.UUID + "(" + this.traces.size() + " traces)");
        if (this.traces.isEmpty()) {
            this.rootTrace.traceMachine = null;
            this.complete = true;
            Measurements.endActivityWithoutMeasurement(this.measuredActivity);
            return;
        }
        this.measuredActivity.setEndTime(this.rootTrace.exitTimestamp);
        Measurements.endActivity(this.measuredActivity);
        this.rootTrace.traceMachine = null;
        this.complete = true;
        TaskQueue.queue(this);
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray tree = new JsonArray();
        if (!this.complete) {
            this.log.debug("Attempted to serialize trace " + this.rootTrace.UUID + " but it has yet to be finalized");
            return null;
        }
        tree.add(new Gson().toJsonTree(this.params, GSON_STRING_MAP_TYPE));
        tree.add(new JsonPrimitive(this.rootTrace.entryTimestamp));
        tree.add(new JsonPrimitive(this.rootTrace.exitTimestamp));
        tree.add(new JsonPrimitive(this.rootTrace.displayName));
        JsonArray segments = new JsonArray();
        segments.add(this.getEnvironment());
        segments.add(this.traceToTree(this.rootTrace));
        segments.add(this.getVitalsAsJson());
        tree.add(segments);
        return tree;
    }

    private JsonArray traceToTree(Trace trace) {
        JsonArray segment = new JsonArray();
        segment.add(new Gson().toJsonTree(trace.params, GSON_STRING_MAP_TYPE));
        segment.add(new JsonPrimitive(trace.entryTimestamp));
        segment.add(new JsonPrimitive(trace.exitTimestamp));
        segment.add(new JsonPrimitive(trace.displayName));
        JsonArray threadData = new JsonArray();
        threadData.add(new JsonPrimitive(trace.threadId));
        threadData.add(new JsonPrimitive(trace.threadName));
        segment.add(threadData);
        if (trace.getChildren().isEmpty()) {
            segment.add(new JsonArray());
        } else {
            JsonArray children = new JsonArray();
            for (String UUID2 : trace.getChildren()) {
                Trace childTrace = this.traces.get(UUID2);
                if (childTrace == null) continue;
                children.add(this.traceToTree(childTrace));
            }
            segment.add(children);
        }
        return segment;
    }

    private JsonArray getEnvironment() {
        JsonArray environment = new JsonArray();
        environment.add(new Gson().toJsonTree(environmentType, GSON_STRING_MAP_TYPE));
        ConnectInformation connectInformation = new ConnectInformation();
        environment.addAll(connectInformation.asJsonArray());
        HashMap<String, String> environmentParams = new HashMap<String, String>();
        environmentParams.put("size", this.size);
        environment.add(new Gson().toJsonTree(environmentParams, GSON_STRING_MAP_TYPE));
        return environment;
    }

    public void setVitals(Map<Sample.SampleType, Collection<Sample>> vitals) {
        this.vitals = vitals;
    }

    private JsonArray getVitalsAsJson() {
        JsonArray vitalsJson = new JsonArray();
        vitalsJson.add(new Gson().toJsonTree(vitalsType, GSON_STRING_MAP_TYPE));
        JsonObject vitalsMap = new JsonObject();
        if (this.vitals != null) {
            for (Map.Entry<Sample.SampleType, Collection<Sample>> entry : this.vitals.entrySet()) {
                JsonArray samplesJsonArray = new JsonArray();
                for (Sample sample : entry.getValue()) {
                    samplesJsonArray.add(sample.asJsonArray());
                }
                vitalsMap.add(entry.getKey().toString(), samplesJsonArray);
            }
        }
        vitalsJson.add(vitalsMap);
        return vitalsJson;
    }

    public void setLastUpdatedAt(long lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public long getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public long getReportAttemptCount() {
        return this.reportAttemptCount;
    }

    public void incrementReportAttemptCount() {
        ++this.reportAttemptCount;
    }
}

