/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import android.content.Context;
import com.newrelic.agent.android.AndroidAgentImpl;
import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.logging.AndroidAgentLog;
import com.newrelic.agent.android.logging.NullAgentLog;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.newrelic.agent.android.metric.MetricUnit;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.util.NetworkFailure;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRelic {
    private static final String DEFAULT_COLLECTOR_ADDR = "mobile-collector.newrelic.com";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static boolean started = false;
    private final String token;
    private String appName;
    private String collectorAddress = "mobile-collector.newrelic.com";
    private boolean ssl = true;
    private boolean loggingEnabled = true;
    private boolean locationServicesEnabled = false;

    private NewRelic(String token) {
        this.token = token;
    }

    public static NewRelic withApplicationToken(String token) {
        return new NewRelic(token);
    }

    public NewRelic usingSsl(boolean useSsl) {
        this.ssl = useSsl;
        return this;
    }

    public NewRelic usingCollectorAddress(String address) {
        this.collectorAddress = address;
        return this;
    }

    public NewRelic withLocationServiceEnabled(boolean enabled) {
        this.locationServicesEnabled = enabled;
        return this;
    }

    public NewRelic withLoggingEnabled(boolean enabled) {
        this.loggingEnabled = enabled;
        return this;
    }

    public void start(Context context) {
        if (started) {
            log.debug("NewRelic is already running.");
            return;
        }
        try {
            AgentLogManager.setAgentLog(this.loggingEnabled ? new AndroidAgentLog() : new NullAgentLog());
            if (!this.isInstrumented()) {
                log.error("Failed to detect New Relic instrumentation.  Something likely went wrong during your build process and you should contact support@newrelic.com.");
                return;
            }
            AndroidAgentImpl.init(context, this.token, this.collectorAddress, this.ssl, this.locationServicesEnabled, this.appName);
            started = true;
        }
        catch (Throwable e) {
            log.error("Error occurred while starting the New Relic agent!", e);
        }
    }

    private boolean isInstrumented() {
        return false;
    }

    public static void startInteraction(Context activityContext, String actionName) {
        if (NewRelic.isNull(activityContext, "startInteraction: context must be an Activity instance.")) {
            return;
        }
        if (NewRelic.isNull(actionName, "startInteraction: actionName must be an action/method name.")) {
            return;
        }
        TraceMachine.startTracing(activityContext.getClass().getSimpleName() + "#" + actionName.replace("/", "."));
    }

    public static void startInteraction(Context context, String actionName, boolean cancelRunningTrace) {
        if (TraceMachine.isTracingActive() && !cancelRunningTrace) {
            log.warning("startInteraction: An interaction is already being traced, and invalidateActiveTrace is false. This interaction will not be traced.");
            return;
        }
        NewRelic.startInteraction(context, actionName);
    }

    public static void recordMetric(String name, String category, int count, double totalValue, double exclusiveValue) {
        NewRelic.recordMetric(name, category, count, totalValue, exclusiveValue, null, null);
    }

    public static void recordMetric(String name, String category, int count, double totalValue, double exclusiveValue, MetricUnit countUnit, MetricUnit valueUnit) {
        if (NewRelic.isNull(category, "recordMetric: category must not be null. If no MetricCategory is applicable, use MetricCategory.NONE.")) {
            return;
        }
        if (NewRelic.isEmpty(name, "recordMetric: name must not be empty.")) {
            return;
        }
        if (NewRelic.isNegative(count, "recordMetric: count must not be negative.")) {
            return;
        }
        Measurements.addCustomMetric(name, category, count, totalValue, exclusiveValue, countUnit, valueUnit);
    }

    public static void recordMetric(String name, String category, double value) {
        NewRelic.recordMetric(name, category, 1, value, value, null, null);
    }

    public static void noticeHttpTransaction(String url, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        NewRelic.noticeHttpTransaction(url, statusCode, startTime, endTime, bytesSent, bytesReceived, null, null);
    }

    public static void noticeHttpTransaction(String url, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived, String responseBody) {
        NewRelic.noticeHttpTransaction(url, statusCode, startTime, endTime, bytesSent, bytesReceived, responseBody, null);
    }

    public static void noticeHttpTransaction(String url, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params) {
        if (NewRelic.isEmpty(url, "noticeHttpTransaction: url must not be empty.")) {
            return;
        }
        double totalTime = endTime - startTime;
        if (NewRelic.isNegative((int)totalTime, "noticeHttpTransaction: the startTime is later than the endTime, resulting in a negative total time.")) {
            return;
        }
        TaskQueue.queue(new HttpTransactionMeasurement(url, statusCode, 0, startTime, totalTime /= 1000.0, bytesSent, bytesReceived, null));
        if ((long)statusCode >= 400L) {
            Measurements.addHttpError(url, statusCode, responseBody, params);
        }
    }

    public static void noticeNetworkFailure(String url, long startTime, long endTime, NetworkFailure failure) {
        TaskQueue.queue(new HttpTransactionMeasurement(url, 0, failure.getErrorCode(), startTime, endTime, 0L, 0L, null));
    }

    public static void noticeNetworkFailure(String url, long startTime, long endTime, Exception e) {
        if (NewRelic.isEmpty(url, "noticeHttpException: url must not be empty.")) {
            return;
        }
        NetworkFailure failure = NetworkFailure.exceptionToNetworkFailure(e);
        NewRelic.noticeNetworkFailure(url, startTime, endTime, failure);
    }

    private static boolean isNull(Object object, String message) {
        if (object == null) {
            log.error(message);
            return true;
        }
        return false;
    }

    private static boolean isEmpty(String string2, String message) {
        NewRelic.isNull(string2, message);
        if (string2.length() == 0) {
            log.error(message);
            return true;
        }
        return false;
    }

    private static boolean isNegative(int number, String message) {
        if (number < 0) {
            log.error(message);
            return true;
        }
        return false;
    }
}

