/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.util.TypedValue;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.io.FileDescriptor;
import java.io.InputStream;

public class BitmapFactoryInstrumentation {
    private BitmapFactoryInstrumentation() {
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeFile(String pathName, BitmapFactory.Options opts) {
        TraceMachine.enterMethod("BitMapFactory#decodeFile");
        Bitmap bitmap = BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeFile(String pathName) {
        TraceMachine.enterMethod("BitMapFactory#decodeFile");
        Bitmap bitmap = BitmapFactory.decodeFile((String)pathName);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, BitmapFactory.Options opts) {
        TraceMachine.enterMethod("BitMapFactory#decodeResourceStream");
        Bitmap bitmap = BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeResource(Resources res, int id, BitmapFactory.Options opts) {
        TraceMachine.enterMethod("BitMapFactory#decodeResource");
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeResource(Resources res, int id) {
        TraceMachine.enterMethod("BitMapFactory#decodeResource");
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)id);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts) {
        TraceMachine.enterMethod("BitMapFactory#decodeByteArray");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        TraceMachine.enterMethod("BitMapFactory#decodeByteArray");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        TraceMachine.enterMethod("BitmapFactory#decodeStream");
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeStream(InputStream is) {
        TraceMachine.enterMethod("BitMapFactory#decodeStream");
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        TraceMachine.enterMethod("BitMapFactory#decodeFileDescriptor");
        Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true)
    public static Bitmap decodeFileDescriptor(FileDescriptor fd) {
        TraceMachine.enterMethod("BitMapFactory#decodeFileDescriptor");
        Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd);
        TraceMachine.exitMethod();
        return bitmap;
    }
}

