/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.httpclient.ContentBufferingResponseEntityImpl;
import com.newrelic.agent.android.instrumentation.httpclient.HttpRequestEntityImpl;
import com.newrelic.agent.android.instrumentation.httpclient.HttpResponseEntityImpl;
import com.newrelic.agent.android.instrumentation.io.CountingInputStream;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.TreeMap;
import javax.net.ssl.SSLException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;

public class TransactionStateUtil {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    public static final int NSURLErrorUnknown = -1;
    public static final int NSURLErrorBadURL = -1000;
    public static final int NSURLErrorTimedOut = -1001;
    public static final int NSURLErrorCannotConnectToHost = -1004;
    public static final int NSURLErrorDNSLookupFailed = -1006;
    public static final int NSURLErrorBadServerResponse = -1011;
    public static final int NSURLErrorSecureConnectionFailed = -1200;
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String APP_DATA_HEADER = "X-NewRelic-App-Data";
    public static final String CROSS_PROCESS_ID_HEADER = "X-NewRelic-ID";

    public static void inspectAndInstrument(TransactionState transactionState, HttpURLConnection conn) {
        transactionState.setUrl(conn.getURL().toString());
        transactionState.setCarrier(Agent.getActiveNetworkCarrier());
    }

    public static void setCrossProcessHeader(HttpURLConnection conn) {
        String crossProcessId = Agent.getCrossProcessId();
        if (crossProcessId != null) {
            conn.setRequestProperty(CROSS_PROCESS_ID_HEADER.toLowerCase(Locale.ENGLISH), crossProcessId);
        }
    }

    public static void inspectAndInstrumentResponse(TransactionState transactionState, HttpURLConnection conn) {
        int contentLength;
        String appData = conn.getHeaderField(APP_DATA_HEADER);
        if (appData != null && !"".equals(appData)) {
            transactionState.setAppData(appData);
        }
        if ((contentLength = conn.getContentLength()) >= 0) {
            transactionState.setBytesReceived(contentLength);
        }
        int statusCode = 0;
        try {
            statusCode = conn.getResponseCode();
        }
        catch (IOException e) {
            log.error("Failed to retrieve response code due to an I/O exception", e);
        }
        catch (NullPointerException e) {
            log.error("Failed to retrieve response code due to underlying (Harmony?) NPE", e);
        }
        transactionState.setStatusCode(statusCode);
    }

    public static HttpRequest inspectAndInstrument(TransactionState transactionState, HttpHost host, HttpRequest request) {
        TransactionStateUtil.addCrossProcessIdHeader(request);
        RequestLine requestLine = request.getRequestLine();
        if (requestLine != null) {
            boolean isAbsoluteUri;
            String uri = requestLine.getUri();
            boolean bl = isAbsoluteUri = uri != null && uri.length() >= 10 && uri.substring(0, 10).indexOf("://") >= 0;
            if (!isAbsoluteUri && uri != null && host != null) {
                String prefix = host.toURI().toString();
                transactionState.setUrl(prefix + (prefix.endsWith("/") || uri.startsWith("/") ? "" : "/") + uri);
            } else if (isAbsoluteUri) {
                transactionState.setUrl(uri);
            }
        }
        if (transactionState.getUrl() == null) {
            try {
                throw new Exception("TransactionData constructor was not provided with a valid URL or host");
            }
            catch (Exception e) {
                AgentLogManager.getAgentLog().error(MessageFormat.format("TransactionStateUtil.inspectAndInstrument(...) for {0} could not determine request URL [host={1}, requestLine={2}]", request.getClass().getCanonicalName(), host, requestLine), e);
                return request;
            }
        }
        transactionState.setCarrier(Agent.getActiveNetworkCarrier());
        TransactionStateUtil.wrapRequestEntity(transactionState, request);
        return request;
    }

    public static HttpUriRequest inspectAndInstrument(TransactionState transactionState, HttpUriRequest request) {
        TransactionStateUtil.addCrossProcessIdHeader((HttpRequest)request);
        transactionState.setUrl(request.getURI().toString());
        transactionState.setCarrier(Agent.getActiveNetworkCarrier());
        TransactionStateUtil.wrapRequestEntity(transactionState, (HttpRequest)request);
        return request;
    }

    private static void addCrossProcessIdHeader(HttpRequest request) {
        String crossProcessId = Agent.getCrossProcessId();
        if (crossProcessId != null) {
            TraceMachine.setCurrentTraceParam("cross_process_data", crossProcessId);
            request.setHeader(CROSS_PROCESS_ID_HEADER, crossProcessId);
        }
    }

    private static void wrapRequestEntity(TransactionState transactionState, HttpRequest request) {
        HttpEntityEnclosingRequest entityEnclosingRequest;
        if (request instanceof HttpEntityEnclosingRequest && (entityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            entityEnclosingRequest.setEntity((HttpEntity)new HttpRequestEntityImpl(entityEnclosingRequest.getEntity(), transactionState));
        }
    }

    public static HttpResponse inspectAndInstrument(TransactionState transactionState, HttpResponse response) {
        transactionState.setStatusCode(response.getStatusLine().getStatusCode());
        Header[] appDataHeader = response.getHeaders(APP_DATA_HEADER);
        if (appDataHeader != null && appDataHeader.length > 0 && !"".equals(appDataHeader[0].getValue())) {
            transactionState.setAppData(appDataHeader[0].getValue());
        }
        Header[] contentLengthHeader = response.getHeaders(CONTENT_LENGTH_HEADER);
        long contentLengthFromHeader = -1L;
        if (contentLengthHeader != null && contentLengthHeader.length > 0) {
            try {
                contentLengthFromHeader = Long.parseLong(contentLengthHeader[0].getValue());
                transactionState.setBytesReceived(contentLengthFromHeader);
                TransactionStateUtil.addTransactionAndErrorData(transactionState, response);
            }
            catch (NumberFormatException e) {
                log.warning("Failed to parse content length: " + e.toString());
            }
        } else if (response.getEntity() != null) {
            response.setEntity((HttpEntity)new HttpResponseEntityImpl(response.getEntity(), transactionState, contentLengthFromHeader));
        } else {
            transactionState.setBytesReceived(0L);
            TransactionStateUtil.addTransactionAndErrorData(transactionState, null);
        }
        return response;
    }

    public static void setErrorCodeFromException(TransactionState transactionState, Exception e) {
        if (e instanceof UnknownHostException) {
            transactionState.setErrorCode(-1006);
        } else if (e instanceof SocketTimeoutException || e instanceof ConnectTimeoutException) {
            transactionState.setErrorCode(-1001);
        } else if (e instanceof ConnectException) {
            transactionState.setErrorCode(-1004);
        } else if (e instanceof MalformedURLException) {
            transactionState.setErrorCode(-1000);
        } else if (e instanceof SSLException) {
            transactionState.setErrorCode(-1200);
        } else if (e instanceof HttpResponseException) {
            transactionState.setStatusCode(((HttpResponseException)e).getStatusCode());
        } else if (e instanceof ClientProtocolException) {
            transactionState.setErrorCode(-1011);
        } else {
            transactionState.setErrorCode(-1);
        }
    }

    private static void addTransactionAndErrorData(TransactionState transactionState, HttpResponse response) {
        TransactionData transactionData = transactionState.end();
        if (transactionData == null) {
            return;
        }
        TaskQueue.queue(new HttpTransactionMeasurement(transactionData.getUrl(), transactionData.getStatusCode(), transactionData.getErrorCode(), transactionData.getTimestamp(), transactionData.getTime(), transactionData.getBytesSent(), transactionData.getBytesReceived(), transactionData.getAppData()));
        if ((long)transactionState.getStatusCode() >= 400L) {
            StringBuilder responseBody = new StringBuilder();
            try {
                InputStream content;
                if (!(response.getEntity() instanceof HttpRequestEntityImpl)) {
                    response.setEntity((HttpEntity)new ContentBufferingResponseEntityImpl(response.getEntity()));
                }
                if ((content = response.getEntity().getContent()) instanceof CountingInputStream) {
                    responseBody.append(((CountingInputStream)content).getBufferAsString());
                } else {
                    log.error("Unable to wrap content stream for entity");
                }
            }
            catch (IllegalStateException e) {
                log.error(e.toString());
            }
            catch (IOException e) {
                log.error(e.toString());
            }
            Header[] contentTypeHeader = response.getHeaders(CONTENT_TYPE_HEADER);
            String contentType = null;
            if (contentTypeHeader != null && contentTypeHeader.length > 0 && !"".equals(contentTypeHeader[0].getValue())) {
                contentType = contentTypeHeader[0].getValue();
            }
            TreeMap<String, String> params = new TreeMap<String, String>();
            if (contentType != null && contentType.length() > 0) {
                params.put("content_type", contentType);
            }
            params.put("content_length", transactionState.getBytesReceived() + "");
            Measurements.addHttpError(transactionData.getUrl(), transactionData.getStatusCode(), responseBody.toString(), params);
        }
    }
}

