/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.tracing;

import com.newrelic.agent.android.instrumentation.MetricCategory;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.tracing.TraceType;
import com.newrelic.agent.android.tracing.TracingInactiveException;
import com.newrelic.agent.android.util.Util;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;

public class Trace {
    private static final String CATEGORY_PARAMETER = "category";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    public String parentUUID;
    public String UUID;
    public long entryTimestamp = 0L;
    public long exitTimestamp = 0L;
    public long exclusiveTime = 0L;
    public long childExclusiveTime = 0L;
    public String metricName;
    public String metricBackgroundName;
    public String displayName;
    public String scope;
    public long threadId = 0L;
    public String threadName = "main";
    public HashMap<String, Object> params;
    public HashMap<String, Object> annotationParams;
    private TraceType type;
    private boolean isComplete = false;
    private Set<String> children;
    public TraceMachine traceMachine;

    public Trace() {
        this.parentUUID = null;
        this.UUID = java.util.UUID.randomUUID().toString();
        this.children = Util.newStringSetFromMapProxy(this.children);
        this.type = TraceType.TRACE;
        this.params = new HashMap();
        this.annotationParams = new HashMap();
        this.setType();
    }

    public Trace(String displayName, String parentUUID, TraceMachine traceMachine) {
        this.displayName = displayName;
        this.parentUUID = parentUUID;
        this.traceMachine = traceMachine;
        this.UUID = java.util.UUID.randomUUID().toString();
        this.children = Util.newStringSetFromMapProxy(this.children);
        this.type = TraceType.TRACE;
        this.params = new HashMap();
        this.annotationParams = new HashMap();
        this.setType();
    }

    public void addChild(Trace trace) {
        this.children.add(trace.UUID);
    }

    public Set<String> getChildren() {
        return this.children;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void complete() throws TracingInactiveException {
        if (this.isComplete) {
            log.warning("Attempted to double complete trace " + this.UUID);
            return;
        }
        if (this.exitTimestamp == 0L) {
            this.exitTimestamp = System.currentTimeMillis();
        }
        this.exclusiveTime = this.getDuration() - this.childExclusiveTime;
        this.isComplete = true;
        try {
            this.traceMachine.storeCompletedTrace(this);
        }
        catch (NullPointerException e) {
            throw new TracingInactiveException();
        }
    }

    public TraceType getType() {
        return this.type;
    }

    private void setType() {
        this.params.put("type", this.type.toString());
    }

    public void setType(TraceType traceType) {
        this.type = traceType;
        this.setType();
    }

    public long getDuration() {
        return this.exitTimestamp - this.entryTimestamp;
    }

    public MetricCategory getCategory() {
        if (!this.annotationParams.containsKey(CATEGORY_PARAMETER)) {
            return null;
        }
        Object category = this.annotationParams.get(CATEGORY_PARAMETER);
        if (!(category instanceof MetricCategory)) {
            log.error("Category annotation parameter is not of type MetricCategory");
            return null;
        }
        return (MetricCategory)((Object)category);
    }
}

