/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.harvest.ConnectInformation;
import com.newrelic.agent.android.harvest.HarvestResponse;
import com.newrelic.agent.android.harvest.type.Harvestable;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stats.TicToc;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HarvestConnection {
    public static final int NSURLErrorUnknown = -1;
    public static final int NSURLErrorBadURL = -1000;
    public static final int NSURLErrorTimedOut = -1001;
    public static final int NSURLErrorCannotConnectToHost = -1004;
    public static final int NSURLErrorDNSLookupFailed = -1006;
    public static final int NSURLErrorBadServerResponse = -1011;
    public static final int NSURLErrorSecureConnectionFailed = -1200;
    private final AgentLog log = AgentLogManager.getAgentLog();
    private static final String COLLECTOR_CONNECT_URI = "/mobile/v2/connect";
    private static final String COLLECTOR_DATA_URI = "/mobile/v2/data";
    private static final String APPLICATION_TOKEN_HEADER = "X-App-License-Key";
    private static final String CONNECT_TIME_HEADER = "X-NewRelic-Connect-Time";
    private static final Boolean DISABLE_COMPRESSION_FOR_DEBUGGING = false;
    private String collectorHost;
    private String applicationToken;
    private long serverTimestamp;
    private final HttpClient collectorClient;
    private ConnectInformation connectInformation;
    private boolean useSsl;

    public HarvestConnection() {
        int TIMEOUT_IN_SECONDS = 20;
        int CONNECTION_TIMEOUT = (int)TimeUnit.MILLISECONDS.convert(20L, TimeUnit.SECONDS);
        int SOCKET_BUFFER_SIZE = 8192;
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)CONNECTION_TIMEOUT);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)CONNECTION_TIMEOUT);
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        this.collectorClient = new DefaultHttpClient((HttpParams)params);
    }

    public HttpPost createPost(String uri, String message) {
        String contentEncoding = message.length() <= 512 || DISABLE_COMPRESSION_FOR_DEBUGGING != false ? "identity" : "deflate";
        HttpPost post = new HttpPost(uri);
        post.addHeader("Content-Type", "application/json");
        post.addHeader("Content-Encoding", contentEncoding);
        post.addHeader("User-Agent", System.getProperty("http.agent"));
        if (this.applicationToken == null) {
            this.log.error("Cannot create POST without an Application Token.");
            return null;
        }
        post.addHeader(APPLICATION_TOKEN_HEADER, this.applicationToken);
        if (this.serverTimestamp != 0L) {
            post.addHeader(CONNECT_TIME_HEADER, Long.valueOf(this.serverTimestamp).toString());
        }
        if ("deflate".equals(contentEncoding)) {
            byte[] deflated = this.deflate(message);
            post.setEntity((HttpEntity)new ByteArrayEntity(deflated));
        } else {
            try {
                post.setEntity((HttpEntity)new StringEntity(message, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("UTF-8 is unsupported");
                throw new IllegalArgumentException(e);
            }
        }
        return post;
    }

    public HarvestResponse send(HttpPost post) {
        HttpResponse response;
        HarvestResponse harvestResponse = new HarvestResponse();
        try {
            TicToc timer = new TicToc();
            timer.tic();
            response = this.collectorClient.execute((HttpUriRequest)post);
            harvestResponse.setResponseTime(timer.toc());
        }
        catch (Exception e) {
            this.log.error("Failed to send POST to collector: " + e.getMessage());
            this.recordCollectorError(e);
            return null;
        }
        harvestResponse.setStatusCode(response.getStatusLine().getStatusCode());
        try {
            harvestResponse.setResponseBody(HarvestConnection.readResponse(response));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.error("Failed to retrieve collector response: " + e.getMessage());
        }
        return harvestResponse;
    }

    public HarvestResponse sendConnect() {
        if (this.connectInformation == null) {
            throw new IllegalArgumentException();
        }
        HttpPost connectPost = this.createConnectPost(this.connectInformation.toJsonString());
        if (connectPost == null) {
            this.log.error("Failed to create connect POST");
            return null;
        }
        TicToc timer = new TicToc();
        timer.tic();
        HarvestResponse response = this.send(connectPost);
        StatsEngine.get().sampleTimeMs("Supportability/MobileAgent/Collector/Connect", timer.toc());
        return response;
    }

    public HarvestResponse sendData(Harvestable harvestable) {
        if (harvestable == null) {
            throw new IllegalArgumentException();
        }
        HttpPost dataPost = this.createDataPost(harvestable.toJsonString());
        if (dataPost == null) {
            this.log.error("Failed to create data POST");
            return null;
        }
        return this.send(dataPost);
    }

    public HttpPost createConnectPost(String message) {
        return this.createPost(this.getCollectorConnectUri(), message);
    }

    public HttpPost createDataPost(String message) {
        return this.createPost(this.getCollectorDataUri(), message);
    }

    private byte[] deflate(String message) {
        int DEFLATE_BUFFER_SIZE = 8192;
        Deflater deflater = new Deflater();
        deflater.setInput(message.getBytes());
        deflater.finish();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while (!deflater.finished()) {
            int byteCount = deflater.deflate(buf);
            if (byteCount <= 0) {
                this.log.error("HTTP request contains an incomplete payload");
            }
            baos.write(buf, 0, byteCount);
        }
        deflater.end();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResponse(HttpResponse response) throws IOException {
        int RESPONSE_BUFFER_SIZE = 8192;
        char[] buf = new char[8192];
        StringBuilder sb = new StringBuilder();
        InputStream in = response.getEntity().getContent();
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((n = reader.read(buf)) >= 0) {
                sb.append(buf, 0, n);
            }
        }
        finally {
            in.close();
        }
        return sb.toString();
    }

    private void recordCollectorError(Exception e) {
        StatsEngine.get().inc("Supportability/MobileAgent/Collector/ResponseErrorCodes/" + this.exceptionToErrorCode(e));
    }

    private int exceptionToErrorCode(Exception e) {
        if (e instanceof ClientProtocolException) {
            return -1011;
        }
        if (e instanceof UnknownHostException) {
            return -1006;
        }
        if (e instanceof SocketTimeoutException) {
            return -1001;
        }
        if (e instanceof ConnectTimeoutException) {
            return -1001;
        }
        if (e instanceof ConnectException) {
            return -1004;
        }
        if (e instanceof MalformedURLException) {
            return -1000;
        }
        if (e instanceof SSLException) {
            return -1200;
        }
        return -1;
    }

    private String getCollectorUri(String resource) {
        String protocol = this.useSsl ? "https://" : "http://";
        return protocol + this.collectorHost + resource;
    }

    private String getCollectorConnectUri() {
        return this.getCollectorUri(COLLECTOR_CONNECT_URI);
    }

    private String getCollectorDataUri() {
        return this.getCollectorUri(COLLECTOR_DATA_URI);
    }

    public void setServerTimestamp(long serverTimestamp) {
        this.log.debug("Setting server timestamp: " + serverTimestamp);
        this.serverTimestamp = serverTimestamp;
    }

    public void useSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public void setApplicationToken(String applicationToken) {
        this.applicationToken = applicationToken;
    }

    public void setCollectorHost(String collectorHost) {
        this.collectorHost = collectorHost;
    }

    public void setConnectInformation(ConnectInformation connectInformation) {
        this.connectInformation = connectInformation;
    }

    public ConnectInformation getConnectInformation() {
        return this.connectInformation;
    }
}

