/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement.producer;

import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.newrelic.agent.android.measurement.producer.BaseMeasurementProducer;
import com.newrelic.agent.android.util.Util;

public class NetworkMeasurementProducer
extends BaseMeasurementProducer {
    public NetworkMeasurementProducer() {
        super(MeasurementType.Network);
    }

    public void produceMeasurement(String urlString, int statusCode, int errorCode, long startTime, double totalTime, long bytesSent, long bytesReceived, String appData) {
        String url = Util.sanitizeUrl(urlString);
        if (url == null) {
            return;
        }
        this.produceMeasurement(new HttpTransactionMeasurement(url, statusCode, errorCode, startTime, totalTime, bytesSent, bytesReceived, appData));
    }

    public void produceMeasurement(HttpTransactionMeasurement transactionMeasurement) {
        String url = Util.sanitizeUrl(transactionMeasurement.getUrl());
        if (url == null) {
            return;
        }
        transactionMeasurement.setUrl(url);
        super.produceMeasurement(transactionMeasurement);
    }
}

