/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.sample;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import android.os.Process;
import com.newrelic.agent.android.harvest.type.Harvestable;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.Sample;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sampler
implements TraceLifecycleAware,
Runnable {
    private static final long SAMPLE_FREQ_MS = 100L;
    private static final int[] PID = new int[]{Process.myPid()};
    private static final int KB_IN_MB = 1024;
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final ReentrantLock samplerLock = new ReentrantLock();
    private static Sampler sampler;
    private final ActivityManager activityManager;
    private final EnumMap<Sample.SampleType, Collection<Sample>> samples = new EnumMap(Sample.SampleType.class);
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private ScheduledFuture sampleFuture;

    private Sampler(Context context) {
        this.activityManager = (ActivityManager)context.getSystemService("activity");
        this.samples.put(Sample.SampleType.MEMORY, new CopyOnWriteArrayList());
    }

    public static void init(Context context) {
        samplerLock.lock();
        sampler = new Sampler(context);
        samplerLock.unlock();
        TraceMachine.addTraceListener(sampler);
    }

    public static void start() {
        samplerLock.lock();
        if (sampler == null) {
            return;
        }
        sampler.schedule();
        samplerLock.unlock();
        log.debug("Sampler started");
    }

    public static void stop() {
        if (sampler == null) {
            return;
        }
        sampler.stop(false);
    }

    public static void stopNow() {
        if (sampler == null) {
            return;
        }
        sampler.stop(true);
    }

    @Override
    public void run() {
        try {
            if (this.isRunning.get()) {
                this.sample();
            }
        }
        catch (Exception e) {
            log.error("Caught exception while running the sampler", e);
        }
    }

    private void schedule() {
        if (this.isRunning.get()) {
            return;
        }
        this.clear();
        this.isRunning.set(true);
        this.sampleFuture = this.scheduler.scheduleAtFixedRate(this, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private void stop(boolean immediate) {
        if (!this.isRunning.get()) {
            return;
        }
        this.isRunning.set(false);
        this.sampleFuture.cancel(immediate);
        log.debug("Sampler stopped");
    }

    public Map<Sample.SampleType, Collection<Sample>> copySamples() {
        EnumMap<Sample.SampleType, Collection<Sample>> copy = new EnumMap<Sample.SampleType, Collection<Sample>>(this.samples);
        for (Sample.SampleType key : this.samples.keySet()) {
            copy.put(key, new ArrayList<Sample>(this.samples.get((Object)key)));
        }
        return Collections.unmodifiableMap(copy);
    }

    public Collection<Sample> getSamples(Harvestable.Type type) {
        return Collections.unmodifiableCollection(this.samples.get((Object)type));
    }

    private void sample() {
        Sample memorySample = Sampler.sampleMemory();
        if (memorySample != null) {
            this.getSampleCollection(Sample.SampleType.MEMORY).add(memorySample);
        }
    }

    private void clear() {
        for (Collection<Sample> sampleCollection : this.samples.values()) {
            sampleCollection.clear();
        }
    }

    public static Sample sampleMemory() {
        if (sampler != null) {
            Sample sample = new Sample(Sample.SampleType.MEMORY);
            Debug.MemoryInfo[] memInfo = Sampler.sampler.activityManager.getProcessMemoryInfo(PID);
            int totalPss = memInfo[0].getTotalPss();
            if (totalPss >= 0) {
                sample.setSampleValue((double)totalPss / 1024.0);
                return sample;
            }
        }
        return null;
    }

    private Collection<Sample> getSampleCollection(Sample.SampleType type) {
        return this.samples.get((Object)type);
    }

    @Override
    public void onEnterMethod() {
        if (this.isRunning.get()) {
            return;
        }
        Sampler.start();
    }

    @Override
    public void onExitMethod() {
    }

    @Override
    public void onTraceStart(ActivityTrace activityTrace) {
        Sampler.start();
    }

    @Override
    public void onTraceComplete(ActivityTrace activityTrace) {
        Sampler.stop();
        activityTrace.setVitals(this.copySamples());
        this.clear();
    }
}

