/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stats;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.metric.Metric;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatsEngine
extends HarvestAdapter {
    public static final StatsEngine INSTANCE = new StatsEngine();
    public boolean enabled = true;
    private ConcurrentHashMap<String, Metric> statsMap = new ConcurrentHashMap();
    private static final AgentLog log = AgentLogManager.getAgentLog();

    private StatsEngine() {
    }

    public static StatsEngine get() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inc(String name) {
        Metric m;
        Metric metric = m = this.lazyGet(name);
        synchronized (metric) {
            m.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inc(String name, long count) {
        Metric m;
        Metric metric = m = this.lazyGet(name);
        synchronized (metric) {
            m.increment(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(String name, float value) {
        Metric m;
        Metric metric = m = this.lazyGet(name);
        synchronized (metric) {
            m.sample(value);
        }
    }

    public void sampleTimeMs(String name, long time) {
        this.sample(name, (float)time / 1000.0f);
    }

    public static void populateMetrics() {
        for (Map.Entry<String, Metric> entry : INSTANCE.getStatsMap().entrySet()) {
            Metric metric = entry.getValue();
            TaskQueue.queue(metric);
        }
    }

    @Override
    public void onHarvest() {
        StatsEngine.populateMetrics();
        StatsEngine.reset();
    }

    public static void reset() {
        INSTANCE.getStatsMap().clear();
    }

    public static synchronized void disable() {
        StatsEngine.INSTANCE.enabled = false;
    }

    public static synchronized void enable() {
        StatsEngine.INSTANCE.enabled = true;
    }

    private ConcurrentHashMap<String, Metric> getStatsMap() {
        return this.statsMap;
    }

    private Metric lazyGet(String name) {
        Metric m = this.statsMap.get(name);
        if (m == null) {
            m = new Metric(name);
            if (this.enabled) {
                this.statsMap.put(name, m);
            }
        }
        return m;
    }
}

