/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.tracing;

import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.activity.NamedActivity;
import com.newrelic.agent.android.harvest.ConnectInformation;
import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.Sample;
import com.newrelic.agent.android.tracing.Trace;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ActivityTrace
extends HarvestableArray {
    public static final String TRACE_VERSION = "1.0";
    public static final int MAX_TRACES = 2000;
    public Trace rootTrace;
    private final ConcurrentHashMap<UUID, Trace> traces = new ConcurrentHashMap();
    private int traceCount = 0;
    private final Set<UUID> missingChildren = Collections.synchronizedSet(new HashSet());
    private NamedActivity measuredActivity;
    private long reportAttemptCount = 0L;
    public long lastUpdatedAt;
    public long startedAt;
    private boolean complete = false;
    private final HashMap<String, String> params = new HashMap();
    private Map<Sample.SampleType, Collection<Sample>> vitals;
    private final AgentLog log = AgentLogManager.getAgentLog();
    private String size = "NORMAL";
    private static final HashMap<String, String> environmentType = new HashMap<String, String>(){
        {
            this.put("type", "ENVIRONMENT");
        }
    };
    private static final HashMap<String, String> vitalsType = new HashMap<String, String>(){
        {
            this.put("type", "VITALS");
        }
    };

    public ActivityTrace() {
    }

    public ActivityTrace(Trace rootTrace) {
        this.rootTrace = rootTrace;
        this.startedAt = this.lastUpdatedAt = rootTrace.entryTimestamp;
        this.params.put("traceVersion", TRACE_VERSION);
        this.params.put("type", "ACTIVITY");
        this.measuredActivity = (NamedActivity)Measurements.startActivity(rootTrace.metricName);
        this.measuredActivity.setStartTime(rootTrace.entryTimestamp);
        this.measuredActivity.setBackgroundName(rootTrace.metricBackgroundName);
    }

    public void addTrace(Trace trace) {
        this.missingChildren.add(trace.myUUID);
        this.lastUpdatedAt = System.currentTimeMillis();
    }

    public void addCompletedTrace(Trace trace) {
        trace.traceMachine = null;
        this.missingChildren.remove(trace.myUUID);
        if (this.traceCount > 2000) {
            this.log.debug("Maximum trace limit reached, discarding trace " + trace.myUUID);
            return;
        }
        this.traces.put(trace.myUUID, trace);
        ++this.traceCount;
        if (trace.exitTimestamp > this.rootTrace.exitTimestamp) {
            this.rootTrace.exitTimestamp = trace.exitTimestamp;
        }
        if (this.log.getLevel() == 5) {
            this.log.debug("Added trace " + trace.myUUID.toString() + " missing children: " + this.missingChildren.size());
        }
        this.lastUpdatedAt = System.currentTimeMillis();
    }

    public boolean hasMissingChildren() {
        return !this.missingChildren.isEmpty();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void complete() {
        if (this.log.getLevel() == 5) {
            this.log.debug("Completing trace of " + this.rootTrace.displayName + ":" + this.rootTrace.myUUID.toString() + "(" + this.traces.size() + " traces)");
        }
        if (this.traces.isEmpty()) {
            this.rootTrace.traceMachine = null;
            this.complete = true;
            Measurements.endActivityWithoutMeasurement(this.measuredActivity);
            return;
        }
        this.measuredActivity.setEndTime(this.rootTrace.exitTimestamp);
        Measurements.endActivity(this.measuredActivity);
        this.rootTrace.traceMachine = null;
        this.complete = true;
        TaskQueue.queue(this);
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray tree = new JsonArray();
        if (!this.complete) {
            this.log.debug("Attempted to serialize trace " + this.rootTrace.myUUID.toString() + " but it has yet to be finalized");
            return null;
        }
        tree.add(new Gson().toJsonTree(this.params, GSON_STRING_MAP_TYPE));
        tree.add(new JsonPrimitive(this.rootTrace.entryTimestamp));
        tree.add(new JsonPrimitive(this.rootTrace.exitTimestamp));
        tree.add(new JsonPrimitive(this.rootTrace.displayName));
        JsonArray segments = new JsonArray();
        segments.add(this.getEnvironment());
        segments.add(this.traceToTree(this.rootTrace));
        segments.add(this.getVitalsAsJson());
        tree.add(segments);
        return tree;
    }

    private JsonArray traceToTree(Trace trace) {
        JsonArray segment = new JsonArray();
        trace.prepareForSerialization();
        segment.add(new Gson().toJsonTree(trace.getParams(), GSON_STRING_MAP_TYPE));
        segment.add(new JsonPrimitive(trace.entryTimestamp));
        segment.add(new JsonPrimitive(trace.exitTimestamp));
        segment.add(new JsonPrimitive(trace.displayName));
        JsonArray threadData = new JsonArray();
        threadData.add(new JsonPrimitive(trace.threadId));
        threadData.add(new JsonPrimitive(trace.threadName));
        segment.add(threadData);
        if (trace.getChildren().isEmpty()) {
            segment.add(new JsonArray());
        } else {
            JsonArray children = new JsonArray();
            for (UUID traceUUID : trace.getChildren()) {
                Trace childTrace = this.traces.get(traceUUID);
                if (childTrace == null) continue;
                children.add(this.traceToTree(childTrace));
            }
            segment.add(children);
        }
        return segment;
    }

    private JsonArray getEnvironment() {
        JsonArray environment = new JsonArray();
        environment.add(new Gson().toJsonTree(environmentType, GSON_STRING_MAP_TYPE));
        ConnectInformation connectInformation = new ConnectInformation();
        environment.addAll(connectInformation.asJsonArray());
        HashMap<String, String> environmentParams = new HashMap<String, String>();
        environmentParams.put("size", this.size);
        environment.add(new Gson().toJsonTree(environmentParams, GSON_STRING_MAP_TYPE));
        return environment;
    }

    public void setVitals(Map<Sample.SampleType, Collection<Sample>> vitals) {
        this.vitals = vitals;
    }

    private JsonArray getVitalsAsJson() {
        JsonArray vitalsJson = new JsonArray();
        vitalsJson.add(new Gson().toJsonTree(vitalsType, GSON_STRING_MAP_TYPE));
        JsonObject vitalsMap = new JsonObject();
        if (this.vitals != null) {
            for (Map.Entry<Sample.SampleType, Collection<Sample>> entry : this.vitals.entrySet()) {
                JsonArray samplesJsonArray = new JsonArray();
                for (Sample sample : entry.getValue()) {
                    if (sample.getTimestamp() > this.lastUpdatedAt) continue;
                    samplesJsonArray.add(sample.asJsonArray());
                }
                vitalsMap.add(entry.getKey().toString(), samplesJsonArray);
            }
        }
        vitalsJson.add(vitalsMap);
        return vitalsJson;
    }

    public void setLastUpdatedAt(long lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public long getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public long getReportAttemptCount() {
        return this.reportAttemptCount;
    }

    public void incrementReportAttemptCount() {
        ++this.reportAttemptCount;
    }
}

