/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.instrumentation.MetricCategory;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.TraceConstructor;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;

public class JSONArrayInstrumentation {
    private static final ArrayList<String> categoryParams = new ArrayList<String>(Arrays.asList("category", MetricCategory.class.getName(), "JSON"));

    JSONArrayInstrumentation() {
    }

    @TraceConstructor
    public static JSONArray init(String json) throws JSONException {
        JSONArray jsonArray;
        try {
            TraceMachine.enterMethod("JSONArray#<init>", categoryParams);
            jsonArray = new JSONArray(json);
            TraceMachine.exitMethod();
        }
        catch (JSONException e) {
            TraceMachine.exitMethod();
            throw e;
        }
        return jsonArray;
    }

    @ReplaceCallSite(scope="org.json.JSONArray")
    public static String toString(JSONArray jsonArray) {
        TraceMachine.enterMethod("JSONArray#toString", categoryParams);
        String jsonString = jsonArray.toString();
        TraceMachine.exitMethod();
        return jsonString;
    }

    @ReplaceCallSite(scope="org.json.JSONArray")
    public static String toString(JSONArray jsonArray, int indentFactor) throws JSONException {
        String jsonString;
        try {
            TraceMachine.enterMethod("JSONArray#toString", categoryParams);
            jsonString = jsonArray.toString(indentFactor);
            TraceMachine.exitMethod();
        }
        catch (JSONException e) {
            TraceMachine.exitMethod();
            throw e;
        }
        return jsonString;
    }
}

