/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.tracing;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.v2.TraceFieldInterface;
import com.newrelic.agent.android.api.v2.TraceMachineInterface;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.Trace;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import com.newrelic.agent.android.tracing.TraceType;
import com.newrelic.agent.android.tracing.TracingInactiveException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;

public class TraceMachine
extends HarvestAdapter {
    public static final String NR_TRACE_FIELD = "_nr_trace";
    public static final String NR_TRACE_TYPE = "Lcom/newrelic/agent/android/tracing/Trace;";
    public static final String ACTIVITY_METRIC_PREFIX = "Mobile/Activity/Name/";
    public static final String ACTIVITY_BACKGROUND_METRIC_PREFIX = "Mobile/Activity/Background/Name/";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    public static final int HEALTHY_TRACE_TIMEOUT = 500;
    public static final int UNHEALTHY_TRACE_TIMEOUT = 60000;
    private static final Collection<TraceLifecycleAware> traceListeners = new CopyOnWriteArrayList<TraceLifecycleAware>();
    private static ThreadLocal<Trace> threadLocalTrace = new ThreadLocal();
    private static ThreadLocal<TraceStack> threadLocalTraceStack = new ThreadLocal();
    private static TraceMachine traceMachine = null;
    private static TraceMachineInterface traceMachineInterface;
    private ActivityTrace activityTrace;

    protected TraceMachine(Trace rootTrace) {
        this.activityTrace = new ActivityTrace(rootTrace);
        Harvest.addHarvestListener(this);
    }

    public static TraceMachine getTraceMachine() {
        return traceMachine;
    }

    public static void addTraceListener(TraceLifecycleAware listener) {
        traceListeners.add(listener);
    }

    public static void removeTraceListener(TraceLifecycleAware listener) {
        traceListeners.remove(listener);
    }

    public static void setTraceMachineInterface(TraceMachineInterface traceMachineInterface) {
        TraceMachine.traceMachineInterface = traceMachineInterface;
    }

    public static void startTracing(String name) {
        try {
            if (!Harvest.shouldCollectActivityTraces()) {
                return;
            }
            Trace rootTrace = new Trace();
            rootTrace.metricName = TraceMachine.formatMetricName(name);
            rootTrace.metricBackgroundName = TraceMachine.formatBackgroundMetricName(name);
            rootTrace.displayName = name;
            rootTrace.entryTimestamp = System.currentTimeMillis();
            log.debug("Started trace of " + name + ":" + rootTrace.myUUID.toString());
            if (TraceMachine.isTracingActive()) {
                traceMachine.completeActivityTrace();
            }
            threadLocalTrace.remove();
            threadLocalTraceStack.set(new TraceStack());
            rootTrace.traceMachine = traceMachine = new TraceMachine(rootTrace);
            TraceMachine.pushTraceContext(rootTrace);
            for (TraceLifecycleAware listener : traceListeners) {
                listener.onTraceStart(TraceMachine.traceMachine.activityTrace);
            }
        }
        catch (Throwable e) {
            log.error("Caught error while initializing TraceMachine, shutting it down", e);
            StatsEngine.get().inc("Supportability/MobileAgent/Exception/TraceMachine/startTracing/" + e.getClass().getName());
            traceMachine = null;
            threadLocalTrace.remove();
            threadLocalTraceStack.remove();
        }
    }

    public static void haltTracing() {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        traceMachine.completeActivityTrace();
        threadLocalTrace.remove();
        threadLocalTraceStack.remove();
    }

    private static String formatMetricName(String name) {
        return ACTIVITY_METRIC_PREFIX + name;
    }

    private static String formatBackgroundMetricName(String name) {
        return ACTIVITY_BACKGROUND_METRIC_PREFIX + name;
    }

    private static Trace registerNewTrace(String name) throws TracingInactiveException {
        if (TraceMachine.isTracingInactive()) {
            log.debug("Tried to register a new trace but tracing is inactive!");
            throw new TracingInactiveException();
        }
        Trace parentTrace = TraceMachine.getCurrentTrace();
        Trace childTrace = new Trace(name, parentTrace.myUUID, traceMachine);
        try {
            TraceMachine.traceMachine.activityTrace.addTrace(childTrace);
        }
        catch (Exception e) {
            throw new TracingInactiveException();
        }
        if (log.getLevel() == 5) {
            log.debug("Registering trace of " + name + " with parent " + parentTrace.displayName);
        }
        parentTrace.addChild(childTrace);
        return childTrace;
    }

    private void completeActivityTrace() {
        TraceMachine finishedMachine = traceMachine;
        traceMachine = null;
        for (TraceLifecycleAware listener : traceListeners) {
            listener.onTraceComplete(finishedMachine.activityTrace);
        }
        finishedMachine.activityTrace.complete();
        Harvest.removeHarvestListener(finishedMachine);
    }

    public static void enterNetworkSegment(String name) {
        try {
            if (TraceMachine.isTracingInactive()) {
                return;
            }
            Trace currentTrace = TraceMachine.getCurrentTrace();
            if (currentTrace.getType() == TraceType.NETWORK) {
                TraceMachine.exitMethod();
            }
            TraceMachine.enterMethod(null, name, null);
            Trace networkTrace = TraceMachine.getCurrentTrace();
            networkTrace.setType(TraceType.NETWORK);
        }
        catch (TracingInactiveException e) {
        }
        catch (Throwable e) {
            log.error("Caught error while calling enterNetworkSegment()", e);
            StatsEngine.get().inc("Supportability/MobileAgent/Exception/TraceMachine/enterNetworkSegment/" + e.getClass().getName());
        }
    }

    public static void enterMethod(String name) {
        TraceMachine.enterMethod(null, name, null);
    }

    public static void enterMethod(String name, ArrayList<String> annotationParams) {
        TraceMachine.enterMethod(null, name, annotationParams);
    }

    public static void enterMethod(Trace trace, String name, ArrayList<String> annotationParams) {
        try {
            if (TraceMachine.isTracingInactive()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long lastUpdatedAt = TraceMachine.traceMachine.activityTrace.lastUpdatedAt;
            long inception = TraceMachine.traceMachine.activityTrace.startedAt;
            if (lastUpdatedAt + 500L < currentTime && !TraceMachine.traceMachine.activityTrace.hasMissingChildren()) {
                log.debug("Completing activity trace after hitting healthy timeout (500ms)");
                traceMachine.completeActivityTrace();
                return;
            }
            if (inception + 60000L < currentTime) {
                log.debug("Completing activity trace after hitting unhealthy timeout (60000ms)");
                traceMachine.completeActivityTrace();
                return;
            }
            TraceMachine.loadTraceContext(trace);
            Trace childTrace = TraceMachine.registerNewTrace(name);
            TraceMachine.pushTraceContext(childTrace);
            childTrace.scope = TraceMachine.getCurrentScope();
            childTrace.setAnnotationParams(annotationParams);
            for (TraceLifecycleAware listener : traceListeners) {
                listener.onEnterMethod();
            }
            childTrace.entryTimestamp = System.currentTimeMillis();
        }
        catch (TracingInactiveException e) {
        }
        catch (Throwable e) {
            log.error("Caught error while calling enterMethod()", e);
            StatsEngine.get().inc("Supportability/MobileAgent/Exception/TraceMachine/enterMethod/" + e.getClass().getName());
        }
    }

    public static void exitMethod() {
        try {
            if (TraceMachine.isTracingInactive()) {
                return;
            }
            Trace trace = threadLocalTrace.get();
            if (trace == null) {
                log.debug("threadLocalTrace is null");
                return;
            }
            trace.exitTimestamp = System.currentTimeMillis();
            if (trace.threadId == 0L && traceMachineInterface != null) {
                trace.threadId = traceMachineInterface.getCurrentThreadId();
                trace.threadName = traceMachineInterface.getCurrentThreadName();
            }
            for (TraceLifecycleAware listener : traceListeners) {
                listener.onExitMethod();
            }
            try {
                trace.complete();
            }
            catch (TracingInactiveException e) {
                threadLocalTrace.remove();
                threadLocalTraceStack.remove();
                TaskQueue.queue(trace);
                return;
            }
            threadLocalTraceStack.get().pop();
            if (threadLocalTraceStack.get().empty()) {
                threadLocalTrace.set(null);
            } else {
                Trace parentTrace = (Trace)threadLocalTraceStack.get().peek();
                threadLocalTrace.set(parentTrace);
                parentTrace.childExclusiveTime += trace.getDuration();
            }
            if (trace.getType() == TraceType.TRACE) {
                TaskQueue.queue(trace);
            }
        }
        catch (Throwable e) {
            log.error("Caught error while calling exitMethod()", e);
            StatsEngine.get().inc("Supportability/MobileAgent/Exception/TraceMachine/exitMethod/" + e.getClass().getName());
        }
    }

    private static void pushTraceContext(Trace trace) {
        if (TraceMachine.isTracingInactive() || trace == null) {
            return;
        }
        TraceStack traceStack = threadLocalTraceStack.get();
        if (traceStack.empty()) {
            traceStack.push(trace);
        } else if (traceStack.peek() != trace) {
            traceStack.push(trace);
        }
        threadLocalTrace.set(trace);
    }

    private static void loadTraceContext(Trace trace) {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        if (threadLocalTrace.get() == null) {
            threadLocalTrace.set(trace);
            threadLocalTraceStack.set(new TraceStack());
            if (trace == null) {
                return;
            }
            threadLocalTraceStack.get().push(trace);
        } else if (trace == null) {
            if (threadLocalTraceStack.get().isEmpty()) {
                if (log.getLevel() == 5) {
                    log.debug("No context to load!");
                }
                threadLocalTrace.set(null);
                return;
            }
            trace = (Trace)threadLocalTraceStack.get().peek();
            threadLocalTrace.set(trace);
        }
        if (log.getLevel() == 5) {
            log.debug("Trace " + trace.myUUID.toString() + " is now active");
        }
    }

    public static void unloadTraceContext(Object object) {
        try {
            if (TraceMachine.isTracingInactive()) {
                return;
            }
            if (traceMachineInterface != null && traceMachineInterface.isUIThread()) {
                return;
            }
            if (threadLocalTrace.get() != null && log.getLevel() == 5) {
                log.debug("Trace " + TraceMachine.threadLocalTrace.get().myUUID.toString() + " is now inactive");
            }
            threadLocalTrace.remove();
            threadLocalTraceStack.remove();
            ((TraceFieldInterface)object)._nr_setTrace(null);
        }
        catch (Throwable e) {
            log.error("Caught error while calling unloadTraceContext()", e);
            StatsEngine.get().inc("Supportability/MobileAgent/Exception/TraceMachine/unloadTraceContext/" + e.getClass().getName());
        }
    }

    public static Trace getCurrentTrace() throws TracingInactiveException {
        if (TraceMachine.isTracingInactive()) {
            throw new TracingInactiveException();
        }
        Trace trace = threadLocalTrace.get();
        if (trace != null) {
            return trace;
        }
        return TraceMachine.getRootTrace();
    }

    public static Map<String, Object> getCurrentTraceParams() throws TracingInactiveException {
        return TraceMachine.getCurrentTrace().getParams();
    }

    public static void setCurrentTraceParam(String key, Object value) {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        try {
            TraceMachine.getCurrentTrace().getParams().put(key, value);
        }
        catch (TracingInactiveException e) {
            return;
        }
    }

    public static void setCurrentDisplayName(String name) {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        try {
            TraceMachine.getCurrentTrace().displayName = name;
        }
        catch (TracingInactiveException e) {
            return;
        }
    }

    public static void setRootDisplayName(String name) {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        try {
            Trace rootTrace = TraceMachine.getRootTrace();
            rootTrace.metricName = TraceMachine.formatMetricName(name);
            rootTrace.metricBackgroundName = TraceMachine.formatBackgroundMetricName(name);
            rootTrace.displayName = name;
        }
        catch (TracingInactiveException e) {
            return;
        }
    }

    public static String getCurrentScope() {
        try {
            if (TraceMachine.isTracingInactive()) {
                return null;
            }
            if (traceMachineInterface == null || traceMachineInterface.isUIThread()) {
                return TraceMachine.traceMachine.activityTrace.rootTrace.metricName;
            }
            return TraceMachine.traceMachine.activityTrace.rootTrace.metricBackgroundName;
        }
        catch (Throwable e) {
            log.error("Caught error while calling getCurrentScope()", e);
            StatsEngine.get().inc("Supportability/MobileAgent/Exception/TraceMachine/getCurrentScope/" + e.getClass().getName());
            return null;
        }
    }

    public static boolean isTracingActive() {
        return traceMachine != null;
    }

    public static boolean isTracingInactive() {
        return traceMachine == null;
    }

    public void storeCompletedTrace(Trace trace) {
        try {
            if (TraceMachine.isTracingInactive()) {
                log.debug("Attempted to store a completed trace with no trace machine!");
                return;
            }
            this.activityTrace.addCompletedTrace(trace);
        }
        catch (Throwable e) {
            log.error("Caught error while calling storeCompletedTrace()", e);
            StatsEngine.get().inc("Supportability/MobileAgent/Exception/TraceMachine/storeCompletedTrace/" + e.getClass().getName());
        }
    }

    public static Trace getRootTrace() throws TracingInactiveException {
        try {
            return TraceMachine.traceMachine.activityTrace.rootTrace;
        }
        catch (NullPointerException e) {
            throw new TracingInactiveException();
        }
    }

    public static ActivityTrace getActivityTrace() throws TracingInactiveException {
        try {
            return TraceMachine.traceMachine.activityTrace;
        }
        catch (NullPointerException e) {
            throw new TracingInactiveException();
        }
    }

    @Override
    public void onHarvestBefore() {
        if (TraceMachine.isTracingActive()) {
            long currentTime = System.currentTimeMillis();
            long lastUpdatedAt = TraceMachine.traceMachine.activityTrace.lastUpdatedAt;
            long inception = TraceMachine.traceMachine.activityTrace.startedAt;
            if (lastUpdatedAt + 500L < currentTime && !TraceMachine.traceMachine.activityTrace.hasMissingChildren()) {
                log.debug("Completing activity trace after hitting healthy timeout (500ms)");
                this.completeActivityTrace();
                StatsEngine.get().inc("Supportability/MobileAgent/HealthyActivityTraces");
                return;
            }
            if (inception + 60000L < currentTime) {
                log.debug("Completing activity trace after hitting unhealthy timeout (60000ms)");
                this.completeActivityTrace();
                StatsEngine.get().inc("Supportability/MobileAgent/UnhealthyActivityTraces");
                return;
            }
        } else {
            log.debug("TraceMachine is inactive");
        }
    }

    @Override
    public void onHarvestSendFailed() {
        TraceMachine.traceMachine.activityTrace.incrementReportAttemptCount();
    }

    private static class TraceStack
    extends Stack<Trace> {
        private TraceStack() {
        }
    }
}

