/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import android.content.Context;
import android.content.SharedPreferences;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.harvest.HarvestConfiguration;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;

public class SavedState
extends HarvestAdapter {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final String PREFERENCE_FILE_PREFIX = "com.newrelic.android.agent.v1_";
    private final String PREF_MAX_TRANSACTION_COUNT = "maxTransactionCount";
    private final String PREF_MAX_TRANSACTION_AGE = "maxTransactionAgeInSeconds";
    private final String PREF_HARVEST_INTERVAL = "harvestIntervalInSeconds";
    private final String PREF_SERVER_TIMESTAMP = "serverTimestamp";
    private final String PREF_CROSS_PROCESS_ID = "crossProcessId";
    private final String PREF_AGENT_VERSION = "agentVersion";
    private final String PREF_DATA_TOKEN = "dataToken";
    private final String PREF_APP_TOKEN = "appToken";
    private final String PREF_ANDROID_ID_BUG_WORK_AROUND = "androidIdBugWorkAround";
    private final String PREF_STACK_TRACE_LIMIT = "stackTraceLimit";
    private final String PREF_RESPONSE_BODY_LIMIT = "responseBodyLimit";
    private final String PREF_COLLECT_NETWORK_ERRORS = "collectNetworkErrors";
    private final String PREF_ERROR_LIMIT = "errorLimit";
    private final String NEW_RELIC_AGENT_DISABLED_VERSION_KEY = "NewRelicAgentDisabledVersion";
    private final String PREF_ACTIVITY_TRACE_MIN_UTILIZATION = "activityTraceMinUtilization";
    private final HarvestConfiguration configuration = new HarvestConfiguration();
    private Float activityTraceMinUtilization;
    private final SharedPreferences prefs;
    private final SharedPreferences.Editor editor;
    private final Lock lock = new ReentrantLock();

    public SavedState(Context context) {
        this.prefs = context.getSharedPreferences(this.getPreferenceFileName(context.getPackageName()), 0);
        this.editor = this.prefs.edit();
        this.loadHarvestConfiguration();
    }

    public void saveHarvestConfiguration(HarvestConfiguration newConfiguration) {
        if (this.configuration.equals(newConfiguration)) {
            return;
        }
        if (!newConfiguration.getDataToken().isValid()) {
            newConfiguration.setData_token(this.configuration.getData_token());
        }
        log.info("Saving configuration: " + newConfiguration);
        this.saveDataToken(newConfiguration.getDataToken().toJsonString());
        this.saveCrossProcessId(newConfiguration.getCross_process_id());
        this.saveServerTimestamp(newConfiguration.getServer_timestamp());
        this.saveHarvestInterval(newConfiguration.getData_report_period());
        this.saveMaxTransactionAge(newConfiguration.getReport_max_transaction_age());
        this.saveMaxTransactionCount(newConfiguration.getReport_max_transaction_count());
        this.saveStackTraceLimit(newConfiguration.getStack_trace_limit());
        this.saveResponseBodyLimit(newConfiguration.getResponse_body_limit());
        this.saveCollectNetworkErrors(newConfiguration.isCollect_network_errors());
        this.saveErrorLimit(newConfiguration.getError_limit());
        this.saveActivityTraceMinUtilization((float)newConfiguration.getActivity_trace_min_utilization());
        this.loadHarvestConfiguration();
    }

    public void loadHarvestConfiguration() {
        if (this.has("dataToken")) {
            this.configuration.setData_token(this.getDataToken());
        }
        if (this.has("crossProcessId")) {
            this.configuration.setCross_process_id(this.getCrossProcessId());
        }
        if (this.has("serverTimestamp")) {
            this.configuration.setServer_timestamp(this.getServerTimestamp());
        }
        if (this.has("harvestIntervalInSeconds")) {
            this.configuration.setData_report_period((int)this.getHarvestIntervalInSeconds());
        }
        if (this.has("maxTransactionAgeInSeconds")) {
            this.configuration.setReport_max_transaction_age((int)this.getMaxTransactionAgeInSeconds());
        }
        if (this.has("maxTransactionCount")) {
            this.configuration.setReport_max_transaction_count((int)this.getMaxTransactionCount());
        }
        if (this.has("stackTraceLimit")) {
            this.configuration.setStack_trace_limit(this.getStackTraceLimit());
        }
        if (this.has("responseBodyLimit")) {
            this.configuration.setResponse_body_limit(this.getResponseBodyLimit());
        }
        if (this.has("collectNetworkErrors")) {
            this.configuration.setCollect_network_errors(this.isCollectingNetworkErrors());
        }
        if (this.has("errorLimit")) {
            this.configuration.setError_limit(this.getErrorLimit());
        }
        if (this.has("activityTraceMinUtilization")) {
            this.configuration.setActivity_trace_min_utilization(this.getActivityTraceMinUtilization());
        }
        log.info("Loaded configuration: " + this.configuration);
    }

    public HarvestConfiguration getHarvestConfiguration() {
        return this.configuration;
    }

    private boolean has(String key) {
        return this.prefs.contains(key);
    }

    public void onHarvestConnected() {
        this.saveHarvestConfiguration(Harvest.getHarvestConfiguration());
    }

    public void onHarvestComplete() {
        this.saveHarvestConfiguration(Harvest.getHarvestConfiguration());
    }

    public void onHarvestDisconnected() {
        log.info("Clearing harvest configuration.");
        this.clear();
    }

    public void onHarvestDisabled() {
        String agentVersion = Agent.getDeviceInformation().getAgentVersion();
        log.info("Disabling agent version " + agentVersion);
        this.saveDisabledVersion(agentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String key, String value) {
        this.lock.lock();
        try {
            this.editor.putString(key, value);
            this.editor.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String key, boolean value) {
        this.lock.lock();
        try {
            this.editor.putBoolean(key, value);
            this.editor.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String key, int value) {
        this.lock.lock();
        try {
            this.editor.putInt(key, value);
            this.editor.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String key, long value) {
        this.lock.lock();
        try {
            this.editor.putLong(key, value);
            this.editor.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String key, float value) {
        this.lock.lock();
        try {
            this.editor.putFloat(key, value);
            this.editor.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getString(String key) {
        if (!this.prefs.contains(key)) {
            return null;
        }
        return this.prefs.getString(key, null);
    }

    public boolean getBoolean(String key) {
        return this.prefs.getBoolean(key, false);
    }

    public long getLong(String key) {
        return this.prefs.getLong(key, 0L);
    }

    public int getInt(String key) {
        return this.prefs.getInt(key, 0);
    }

    public Float getFloat(String key) {
        if (!this.prefs.contains(key)) {
            return null;
        }
        float f = this.prefs.getFloat(key, 0.0f);
        return Float.valueOf((float)((int)(f * 100.0f)) / 100.0f);
    }

    public String getDisabledVersion() {
        return this.getString("NewRelicAgentDisabledVersion");
    }

    public void saveDisabledVersion(String version) {
        this.save("NewRelicAgentDisabledVersion", version);
    }

    public int[] getDataToken() {
        int[] dataToken = new int[2];
        String dataTokenString = this.getString("dataToken");
        if (dataTokenString == null) {
            return null;
        }
        try {
            JSONTokener tokener = new JSONTokener(dataTokenString);
            if (tokener == null) {
                return null;
            }
            JSONArray array = (JSONArray)tokener.nextValue();
            if (array == null) {
                return null;
            }
            dataToken[0] = array.getInt(0);
            dataToken[1] = array.getInt(1);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return dataToken;
    }

    public void saveDataToken(String dataToken) {
        log.debug("!! saving data token: " + dataToken);
        this.save("dataToken", dataToken);
    }

    public String getAgentVersion() {
        return this.getString("agentVersion");
    }

    public void saveAgentVersion(String agentVersion) {
        this.save("agentVersion", agentVersion);
    }

    public String getCrossProcessId() {
        return this.getString("crossProcessId");
    }

    public void saveCrossProcessId(String crossProcessId) {
        this.save("crossProcessId", crossProcessId);
    }

    public String getAppToken() {
        return this.getString("appToken");
    }

    public void saveAppToken(String appToken) {
        this.save("appToken", appToken);
    }

    public String getAndroidIdBugWorkAround() {
        return this.getString("androidIdBugWorkAround");
    }

    public void saveAndroidIdBugWorkAround(String androidIdBugWorkAround) {
        this.save("androidIdBugWorkAround", androidIdBugWorkAround);
    }

    public boolean isCollectingNetworkErrors() {
        return this.getBoolean("collectNetworkErrors");
    }

    public void saveCollectNetworkErrors(boolean collectNetworkErrors) {
        this.save("collectNetworkErrors", collectNetworkErrors);
    }

    public long getServerTimestamp() {
        return this.getLong("serverTimestamp");
    }

    public void saveServerTimestamp(long serverTimestamp) {
        this.save("serverTimestamp", serverTimestamp);
    }

    public long getHarvestInterval() {
        return this.getLong("harvestIntervalInSeconds");
    }

    public void saveHarvestInterval(long harvestInterval) {
        this.save("harvestIntervalInSeconds", harvestInterval);
    }

    public long getMaxTransactionAge() {
        return this.getLong("maxTransactionAgeInSeconds");
    }

    public void saveMaxTransactionAge(long maxTransactionAge) {
        this.save("maxTransactionAgeInSeconds", maxTransactionAge);
    }

    public long getMaxTransactionCount() {
        return this.getLong("maxTransactionCount");
    }

    public void saveMaxTransactionCount(long maxTransactionCount) {
        this.save("maxTransactionCount", maxTransactionCount);
    }

    public int getStackTraceLimit() {
        return this.getInt("stackTraceLimit");
    }

    public void saveStackTraceLimit(int stackTraceLimit) {
        this.save("stackTraceLimit", stackTraceLimit);
    }

    public int getResponseBodyLimit() {
        return this.getInt("responseBodyLimit");
    }

    public void saveResponseBodyLimit(int responseBodyLimit) {
        this.save("responseBodyLimit", responseBodyLimit);
    }

    public int getErrorLimit() {
        return this.getInt("errorLimit");
    }

    public void saveErrorLimit(int errorLimit) {
        this.save("errorLimit", errorLimit);
    }

    public void saveActivityTraceMinUtilization(float activityTraceMinUtilization) {
        this.activityTraceMinUtilization = Float.valueOf(activityTraceMinUtilization);
        this.save("activityTraceMinUtilization", activityTraceMinUtilization);
    }

    public float getActivityTraceMinUtilization() {
        if (this.activityTraceMinUtilization == null) {
            this.activityTraceMinUtilization = this.getFloat("activityTraceMinUtilization");
        }
        return this.activityTraceMinUtilization.floatValue();
    }

    public long getHarvestIntervalInSeconds() {
        return this.getHarvestInterval();
    }

    public long getMaxTransactionAgeInSeconds() {
        return this.getMaxTransactionAge();
    }

    private String getPreferenceFileName(String packageName) {
        return "com.newrelic.android.agent.v1_" + packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.editor.clear();
            this.editor.commit();
            this.configuration.setDefaultValues();
        }
        finally {
            this.lock.unlock();
        }
    }
}

