/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.harvest.AgentHealthException;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.newrelic.agent.android.metric.Metric;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.Trace;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TaskQueue
extends HarvestAdapter {
    private static final long DEQUEUE_PERIOD_MS = 1000L;
    private static final ScheduledExecutorService queueExecutor = Executors.newSingleThreadScheduledExecutor();
    private static final ConcurrentLinkedQueue<Object> queue = new ConcurrentLinkedQueue();
    private static final Runnable dequeueTask = new Runnable(){

        @Override
        public void run() {
            TaskQueue.dequeue();
        }
    };
    private static Future dequeueFuture;

    public static void queue(Object object) {
        queue.add(object);
    }

    public static void backgroundDequeue() {
        queueExecutor.execute(dequeueTask);
    }

    public static void synchronousDequeue() {
        Future<?> future = queueExecutor.submit(dequeueTask);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static void start() {
        if (dequeueFuture != null) {
            return;
        }
        dequeueFuture = queueExecutor.scheduleAtFixedRate(dequeueTask, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public static void stop() {
        if (dequeueFuture == null) {
            return;
        }
        dequeueFuture.cancel(true);
        dequeueFuture = null;
    }

    private static void dequeue() {
        if (queue.size() == 0) {
            return;
        }
        Measurements.setBroadcastNewMeasurements(false);
        while (!queue.isEmpty()) {
            try {
                Object object = queue.remove();
                if (object instanceof ActivityTrace) {
                    Harvest.addActivityTrace((ActivityTrace)object);
                    continue;
                }
                if (object instanceof Metric) {
                    Harvest.addMetric((Metric)object);
                    continue;
                }
                if (object instanceof AgentHealthException) {
                    Harvest.addAgentHealthException((AgentHealthException)object);
                    continue;
                }
                if (object instanceof Trace) {
                    Measurements.addTracedMethod((Trace)object);
                    continue;
                }
                if (!(object instanceof HttpTransactionMeasurement)) continue;
                Measurements.addHttpTransaction((HttpTransactionMeasurement)object);
            }
            catch (Exception e) {
                e.printStackTrace();
                AgentHealth.noticeException(e);
            }
        }
        Measurements.broadcast();
        Measurements.setBroadcastNewMeasurements(true);
    }

    public static int size() {
        return queue.size();
    }

    public static void clear() {
        queue.clear();
    }
}

