/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeviceInformation
extends HarvestableArray {
    private String osName;
    private String osVersion;
    private String model;
    private String agentName;
    private String agentVersion;
    private String deviceId;
    private String countryCode;
    private String regionCode;
    private String manufacturer;
    private Map<String, String> misc = new HashMap<String, String>();

    @Override
    public JsonArray asJsonArray() {
        JsonArray array = new JsonArray();
        this.notEmpty(this.osName);
        array.add(new JsonPrimitive(this.osName));
        this.notEmpty(this.osVersion);
        array.add(new JsonPrimitive(this.osVersion));
        this.notEmpty(this.manufacturer);
        this.notEmpty(this.model);
        array.add(new JsonPrimitive(this.manufacturer + " " + this.model));
        this.notEmpty(this.agentName);
        array.add(new JsonPrimitive(this.agentName));
        this.notEmpty(this.agentVersion);
        array.add(new JsonPrimitive(this.agentVersion));
        this.notEmpty(this.deviceId);
        array.add(new JsonPrimitive(this.deviceId));
        array.add(new JsonPrimitive(this.optional(this.countryCode)));
        array.add(new JsonPrimitive(this.optional(this.regionCode)));
        array.add(new JsonPrimitive(this.manufacturer));
        if (this.misc == null || this.misc.isEmpty()) {
            this.misc = Collections.emptyMap();
        }
        JsonElement map = new Gson().toJsonTree(this.misc, GSON_STRING_MAP_TYPE);
        array.add(map);
        return array;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setMisc(Map<String, String> misc) {
        this.misc = new HashMap<String, String>(misc);
    }

    public void addMisc(String key, String value) {
        this.misc.put(key, value);
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getModel() {
        return this.model;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public String toJsonString() {
        return "DeviceInformation{manufacturer='" + this.manufacturer + '\'' + ", osName='" + this.osName + '\'' + ", osVersion='" + this.osVersion + '\'' + ", model='" + this.model + '\'' + ", agentName='" + this.agentName + '\'' + ", agentVersion='" + this.agentVersion + '\'' + ", deviceId='" + this.deviceId + '\'' + ", countryCode='" + this.countryCode + '\'' + ", regionCode='" + this.regionCode + '\'' + '}';
    }
}

