/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.harvest.Harvester;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.TicToc;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class HarvestTimer
implements Runnable {
    private static final long DEFAULT_HARVEST_PERIOD = 60000L;
    private static final long HARVEST_PERIOD_LEEWAY = 1000L;
    private static final long NEVER_TICKED = -1L;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final AgentLog log = AgentLogManager.getAgentLog();
    private ScheduledFuture tickFuture;
    private long period = 60000L;
    protected final Harvester harvester;
    protected long lastTickTime;
    private long startTimeMs;

    public HarvestTimer(Harvester harvester) {
        this.harvester = harvester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HarvestTimer harvestTimer = this;
        synchronized (harvestTimer) {
            try {
                this.tickIfReady();
            }
            catch (Exception e) {
                this.log.error("HarvestTimer: Exception in timer tick: " + e.getMessage());
                e.printStackTrace();
                AgentHealth.noticeException(e);
            }
        }
    }

    private void tickIfReady() {
        long lastTickDelta = this.timeSinceLastTick();
        if (lastTickDelta + 1000L < this.period && lastTickDelta != -1L) {
            this.log.debug("HarvestTimer: Tick is too soon (" + lastTickDelta + " delta) Last tick time: " + this.lastTickTime + " . Skipping.");
            return;
        }
        this.log.debug("HarvestTimer: time since last tick: " + lastTickDelta);
        long tickStart = this.now();
        try {
            this.tick();
        }
        catch (Exception e) {
            this.log.error("HarvestTimer: Exception in timer tick: " + e.getMessage());
            e.printStackTrace();
            AgentHealth.noticeException(e);
        }
        this.lastTickTime = tickStart;
        this.log.debug("Set last tick time to: " + this.lastTickTime);
    }

    protected void tick() {
        this.log.debug("Harvest: tick");
        TicToc t = new TicToc();
        t.tic();
        try {
            this.harvester.execute();
        }
        catch (Exception e) {
            this.log.error("HarvestTimer: Exception in harvest execute: " + e.getMessage());
            e.printStackTrace();
            AgentHealth.noticeException(e);
        }
        this.log.debug("Harvest: executed");
        if (this.harvester.isDisabled()) {
            this.stop();
        }
        long tickDelta = t.toc();
        this.log.debug("HarvestTimer tick took " + tickDelta + "ms");
    }

    public void start() {
        if (this.isRunning()) {
            this.log.warning("HarvestTimer: Attempting to start while already running");
            return;
        }
        if (this.period <= 0L) {
            this.log.error("HarvestTimer: Refusing to start with a period of 0 ms");
            return;
        }
        this.log.debug("HarvestTimer: Starting with a period of " + this.period + "ms");
        this.startTimeMs = System.currentTimeMillis();
        this.tickFuture = this.scheduler.scheduleAtFixedRate(this, 0L, this.period, TimeUnit.MILLISECONDS);
        this.harvester.start();
    }

    public void stop() {
        if (!this.isRunning()) {
            this.log.warning("HarvestTimer: Attempting to stop when not running");
            return;
        }
        this.log.debug("HarvestTimer: Stopped.");
        this.startTimeMs = 0L;
        this.harvester.stop();
        this.tickFuture.cancel(true);
        this.tickFuture = null;
    }

    public void tickNow() {
        final HarvestTimer timer = this;
        ScheduledFuture<?> future = this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                timer.tick();
            }
        }, 0L, TimeUnit.SECONDS);
        try {
            future.get();
        }
        catch (Exception e) {
            this.log.error("Exception waiting for tickNow to finish: " + e.getMessage());
            e.printStackTrace();
            AgentHealth.noticeException(e);
        }
    }

    public boolean isRunning() {
        return this.tickFuture != null;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long timeSinceLastTick() {
        if (this.lastTickTime == 0L) {
            return -1L;
        }
        return this.now() - this.lastTickTime;
    }

    public long timeSinceStart() {
        if (this.startTimeMs == 0L) {
            return 0L;
        }
        return this.now() - this.startTimeMs;
    }

    private long now() {
        return System.currentTimeMillis();
    }
}

