/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement.http;

import com.newrelic.agent.android.measurement.BaseMeasurement;
import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.util.Util;

public class HttpTransactionMeasurement
extends BaseMeasurement {
    private String url;
    private double totalTime;
    private int statusCode;
    private int errorCode;
    private long bytesSent;
    private long bytesReceived;
    private String appData;

    public HttpTransactionMeasurement(String url, int statusCode, long startTime, double totalTime, long bytesSent, long bytesReceived, String appData) {
        super(MeasurementType.Network);
        url = Util.sanitizeUrl(url);
        this.setName(url);
        this.setScope(TraceMachine.getCurrentScope());
        this.setStartTime(startTime);
        this.setEndTime(startTime + (long)((int)totalTime));
        this.setExclusiveTime((int)(totalTime * 1000.0));
        this.statusCode = statusCode;
        this.url = url;
        this.bytesSent = bytesSent;
        this.bytesReceived = bytesReceived;
        this.totalTime = totalTime;
        this.appData = appData;
    }

    public HttpTransactionMeasurement(String url, int statusCode, int errorCode, long startTime, double totalTime, long bytesSent, long bytesReceived, String appData) {
        this(url, statusCode, startTime, totalTime, bytesSent, bytesReceived, appData);
        this.errorCode = errorCode;
    }

    @Override
    public double asDouble() {
        return this.totalTime;
    }

    public String getUrl() {
        return this.url;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public String getAppData() {
        return this.appData;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String toString() {
        return "HttpTransactionMeasurement{url='" + this.url + '\'' + ", totalTime=" + this.totalTime + ", statusCode=" + this.statusCode + ", errorCode=" + this.errorCode + ", bytesSent=" + this.bytesSent + ", bytesReceived=" + this.bytesReceived + ", appData='" + this.appData + '\'' + '}';
    }
}

