/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;

public class Util {
    private static final Random random = new Random();

    public static String slurp(InputStream stream) throws IOException {
        int n;
        char[] buf = new char[8192];
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((n = reader.read(buf)) >= 0) {
            sb.append(buf, 0, n);
        }
        return sb.toString();
    }

    public static String sanitizeUrl(String urlString) {
        URL url;
        if (urlString == null) {
            return null;
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
        StringBuffer sanitizedUrl = new StringBuffer();
        sanitizedUrl.append(url.getProtocol());
        sanitizedUrl.append("://");
        sanitizedUrl.append(url.getHost());
        if (url.getPort() != -1) {
            sanitizedUrl.append(":");
            sanitizedUrl.append(url.getPort());
        }
        sanitizedUrl.append(url.getPath());
        return sanitizedUrl.toString();
    }

    public static Random getRandom() {
        return random;
    }
}

