/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;

public enum NetworkFailure {
    Unknown(-1),
    BadURL(-1000),
    TimedOut(-1001),
    CannotConnectToHost(-1004),
    DNSLookupFailed(-1006),
    BadServerResponse(-1011),
    SecureConnectionFailed(-1200);

    private int errorCode;

    private NetworkFailure(int errorCode) {
        this.errorCode = errorCode;
    }

    public static NetworkFailure exceptionToNetworkFailure(Exception e) {
        NetworkFailure error = Unknown;
        if (e instanceof UnknownHostException) {
            error = DNSLookupFailed;
        } else if (e instanceof SocketTimeoutException || e instanceof ConnectTimeoutException) {
            error = TimedOut;
        } else if (e instanceof ConnectException) {
            error = CannotConnectToHost;
        } else if (e instanceof MalformedURLException) {
            error = BadURL;
        } else if (e instanceof SSLException) {
            error = SecureConnectionFailed;
        } else if (e instanceof HttpResponseException || e instanceof ClientProtocolException) {
            error = BadServerResponse;
        }
        return error;
    }

    public static int exceptionToErrorCode(Exception e) {
        return NetworkFailure.exceptionToNetworkFailure(e).getErrorCode();
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

