/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.harvest.AgentHealthException;
import com.newrelic.agent.android.harvest.AgentHealthExceptions;
import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.com.google.gson.JsonArray;
import java.text.MessageFormat;

public class AgentHealth
extends HarvestableArray {
    private final AgentHealthExceptions agentHealthExceptions = new AgentHealthExceptions();

    public static void noticeException(Exception exception) {
        AgentHealth.noticeException(new AgentHealthException(exception));
    }

    public static void noticeException(AgentHealthException exception) {
        StatsEngine.get().inc(MessageFormat.format("Supportability/AgentHealth/Exception/{0}/{1}/{2}", exception.getSourceClass(), exception.getSourceMethod(), exception.getExceptionClass()));
        TaskQueue.queue(exception);
    }

    public void addException(AgentHealthException exception) {
        this.agentHealthExceptions.add(exception);
    }

    public void clear() {
        this.agentHealthExceptions.clear();
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray data = new JsonArray();
        if (!this.agentHealthExceptions.isEmpty()) {
            data.add(this.agentHealthExceptions.asJsonObject());
        }
        return data;
    }
}

