/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.instrumentation.MetricCategory;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.TraceConstructor;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectInstrumentation {
    private static final ArrayList<String> categoryParams = new ArrayList<String>(Arrays.asList("category", MetricCategory.class.getName(), "JSON"));

    JSONObjectInstrumentation() {
    }

    @TraceConstructor
    public static JSONObject init(String json) throws JSONException {
        JSONObject jsonObject;
        try {
            TraceMachine.enterMethod(null, "JSONObject#<init>", categoryParams);
            jsonObject = new JSONObject(json);
            TraceMachine.exitMethod();
        }
        catch (JSONException e) {
            TraceMachine.exitMethod();
            throw e;
        }
        return jsonObject;
    }

    @ReplaceCallSite(scope="org.json.JSONObject")
    public static String toString(JSONObject jsonObject) {
        TraceMachine.enterMethod(null, "JSONObject#toString", categoryParams);
        String jsonString = jsonObject.toString();
        TraceMachine.exitMethod();
        return jsonString;
    }

    @ReplaceCallSite(scope="org.json.JSONObject")
    public static String toString(JSONObject jsonObject, int indentFactor) throws JSONException {
        String jsonString;
        TraceMachine.enterMethod(null, "JSONObject#toString", categoryParams);
        try {
            jsonString = jsonObject.toString(indentFactor);
            TraceMachine.exitMethod();
        }
        catch (JSONException e) {
            TraceMachine.exitMethod();
            throw e;
        }
        return jsonString;
    }
}

