/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.activity;

import com.newrelic.agent.android.activity.MeasuredActivity;
import com.newrelic.agent.android.measurement.Measurement;
import com.newrelic.agent.android.measurement.MeasurementException;
import com.newrelic.agent.android.measurement.MeasurementPool;
import com.newrelic.agent.android.measurement.ThreadInfo;
import com.newrelic.agent.android.tracing.TraceMachine;

public class BaseMeasuredActivity
implements MeasuredActivity {
    private String name;
    private long startTime;
    private long endTime;
    private ThreadInfo startingThread;
    private ThreadInfo endingThread;
    private boolean autoInstrumented;
    private Measurement startingMeasurement;
    private Measurement endingMeasurement;
    private MeasurementPool measurementPool;
    private boolean finished;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMetricName() {
        return TraceMachine.formatActivityMetricName(this.name);
    }

    @Override
    public String getBackgroundMetricName() {
        return TraceMachine.formatActivityBackgroundMetricName(this.name);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public ThreadInfo getStartingThread() {
        return this.startingThread;
    }

    @Override
    public ThreadInfo getEndingThread() {
        return this.endingThread;
    }

    @Override
    public boolean isAutoInstrumented() {
        return this.autoInstrumented;
    }

    @Override
    public Measurement getStartingMeasurement() {
        return this.startingMeasurement;
    }

    @Override
    public Measurement getEndingMeasurement() {
        return this.endingMeasurement;
    }

    @Override
    public MeasurementPool getMeasurementPool() {
        return this.measurementPool;
    }

    @Override
    public void setName(String name) {
        this.throwIfFinished();
        this.name = name;
    }

    public void setStartTime(long startTime) {
        this.throwIfFinished();
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.throwIfFinished();
        this.endTime = endTime;
    }

    public void setStartingThread(ThreadInfo startingThread) {
        this.throwIfFinished();
        this.startingThread = startingThread;
    }

    public void setEndingThread(ThreadInfo endingThread) {
        this.throwIfFinished();
        this.endingThread = endingThread;
    }

    public void setAutoInstrumented(boolean autoInstrumented) {
        this.throwIfFinished();
        this.autoInstrumented = autoInstrumented;
    }

    public void setStartingMeasurement(Measurement startingMeasurement) {
        this.throwIfFinished();
        this.startingMeasurement = startingMeasurement;
    }

    public void setEndingMeasurement(Measurement endingMeasurement) {
        this.throwIfFinished();
        this.endingMeasurement = endingMeasurement;
    }

    public void setMeasurementPool(MeasurementPool measurementPool) {
        this.throwIfFinished();
        this.measurementPool = measurementPool;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    private void throwIfFinished() {
        if (this.finished) {
            throw new MeasurementException("Cannot modify finished Activity");
        }
    }
}

