/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest.crash;

import com.newrelic.agent.android.harvest.type.HarvestableObject;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;

public class ExceptionInfo
extends HarvestableObject {
    private String className;
    private String message;

    public ExceptionInfo() {
    }

    public ExceptionInfo(Throwable throwable) {
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage() != null ? throwable.getMessage() : "";
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public JsonObject asJsonObject() {
        JsonObject data = new JsonObject();
        data.add("name", new JsonPrimitive(this.className));
        data.add("cause", new JsonPrimitive(this.message));
        return data;
    }

    public static ExceptionInfo newFromJson(JsonObject jsonObject) {
        ExceptionInfo info = new ExceptionInfo();
        info.className = jsonObject.get("name").getAsString();
        info.message = jsonObject.get("cause").getAsString();
        return info;
    }
}

