/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.background;

import com.newrelic.agent.android.background.ApplicationStateEvent;
import com.newrelic.agent.android.background.ApplicationStateListener;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ApplicationStateMonitor
implements Runnable {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private long count = 0L;
    private long snoozeStartTime = 0L;
    private final Object snoozeLock = new Object();
    private final int activitySnoozeTimeInMilliseconds;
    private final ArrayList<ApplicationStateListener> applicationStateListeners = new ArrayList();
    private boolean foregrounded = true;
    private final Object foregroundLock = new Object();
    private static ApplicationStateMonitor instance;

    private ApplicationStateMonitor() {
        this(5, 5, TimeUnit.SECONDS, 5000);
    }

    ApplicationStateMonitor(int initialDelay, int period, TimeUnit timeUnit, int snoozeTimeInMilliseconds) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "[New Relic] App State Monitor");
            }
        });
        this.activitySnoozeTimeInMilliseconds = snoozeTimeInMilliseconds;
        executor.scheduleAtFixedRate(this, initialDelay, period, timeUnit);
        log.info("Application state monitor has started");
    }

    public static ApplicationStateMonitor getInstance() {
        if (instance == null) {
            instance = new ApplicationStateMonitor();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationStateListener(ApplicationStateListener listener) {
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            this.applicationStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationStateListener(ApplicationStateListener listener) {
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            this.applicationStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.foregroundLock;
        synchronized (object) {
            if (this.foregrounded && this.getSnoozeTime() >= (long)this.activitySnoozeTimeInMilliseconds) {
                this.notifyApplicationInBackground();
                this.foregrounded = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uiHidden() {
        Object object = this.foregroundLock;
        synchronized (object) {
            if (this.foregrounded) {
                log.info("UI has become hidden (app backgrounded)");
                this.notifyApplicationInBackground();
                this.foregrounded = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityStopped() {
        Object object = this.foregroundLock;
        synchronized (object) {
            Object object2 = this.snoozeLock;
            synchronized (object2) {
                --this.count;
                if (this.count == 0L) {
                    this.snoozeStartTime = System.currentTimeMillis();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityStarted() {
        Object object = this.foregroundLock;
        synchronized (object) {
            Object object2 = this.snoozeLock;
            synchronized (object2) {
                ++this.count;
                if (this.count == 1L) {
                    this.snoozeStartTime = 0L;
                }
            }
            if (!this.foregrounded) {
                log.verbose("Application appears to be in the foreground");
                this.notifyApplicationInForeground();
                this.foregrounded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyApplicationInBackground() {
        ArrayList<ApplicationStateListener> listeners;
        log.verbose("Application appears to have gone to the background");
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<ApplicationStateListener>(this.applicationStateListeners);
        }
        ApplicationStateEvent e = new ApplicationStateEvent(this);
        for (ApplicationStateListener listener : listeners) {
            listener.applicationBackgrounded(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyApplicationInForeground() {
        ArrayList<ApplicationStateListener> listeners;
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<ApplicationStateListener>(this.applicationStateListeners);
        }
        ApplicationStateEvent e = new ApplicationStateEvent(this);
        for (ApplicationStateListener listener : listeners) {
            listener.applicationForegrounded(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSnoozeTime() {
        Object object = this.foregroundLock;
        synchronized (object) {
            Object object2 = this.snoozeLock;
            synchronized (object2) {
                if (this.snoozeStartTime == 0L) {
                    return 0L;
                }
                return System.currentTimeMillis() - this.snoozeStartTime;
            }
        }
    }
}

