/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonPrimitive;

public class ActivitySighting
extends HarvestableArray {
    private final String name;
    private final long timestampMs;
    private long durationMs = 0L;

    public ActivitySighting(long timestampMs, String name) {
        this.timestampMs = timestampMs;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getTimestampMs() {
        return this.timestampMs;
    }

    public long getDuration() {
        return this.durationMs;
    }

    public void end(long endTimestampMs) {
        this.durationMs = endTimestampMs - this.timestampMs;
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray data = new JsonArray();
        data.add(new JsonPrimitive(this.name));
        data.add(new JsonPrimitive(this.timestampMs));
        data.add(new JsonPrimitive(this.durationMs));
        return data;
    }

    public JsonArray asJsonArrayWithoutDuration() {
        JsonArray data = new JsonArray();
        data.add(new JsonPrimitive(this.timestampMs));
        data.add(new JsonPrimitive(this.name));
        return data;
    }

    public static ActivitySighting newFromJson(JsonArray jsonArray) {
        return new ActivitySighting(jsonArray.get(0).getAsLong(), jsonArray.get(1).getAsString());
    }
}

