/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.harvest.ActivityTraces;
import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.harvest.DataToken;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HttpErrors;
import com.newrelic.agent.android.harvest.HttpTransactions;
import com.newrelic.agent.android.harvest.MachineMeasurements;
import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonPrimitive;

public class HarvestData
extends HarvestableArray {
    private DataToken dataToken = new DataToken();
    private DeviceInformation deviceInformation;
    private double harvestTimeDelta;
    private HttpTransactions httpTransactions = new HttpTransactions();
    private MachineMeasurements machineMeasurements;
    private HttpErrors httpErrors = new HttpErrors();
    private ActivityTraces activityTraces = new ActivityTraces();
    private AgentHealth agentHealth;

    public HarvestData() {
        this.machineMeasurements = new MachineMeasurements();
        this.deviceInformation = Agent.getDeviceInformation();
        this.agentHealth = new AgentHealth();
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray array = new JsonArray();
        array.add(this.dataToken.asJson());
        array.add(this.deviceInformation.asJson());
        array.add(new JsonPrimitive(this.harvestTimeDelta));
        array.add(this.httpTransactions.asJson());
        array.add(this.machineMeasurements.asJson());
        array.add(this.httpErrors.asJson());
        JsonElement activityTracesElement = this.activityTraces.asJson();
        String activityTraceJson = activityTracesElement.toString();
        if (activityTraceJson.length() < Harvest.getHarvestConfiguration().getActivity_trace_max_size()) {
            array.add(activityTracesElement);
        } else {
            StatsEngine.get().sample("Supportability/AgentHealth/BigActivityTracesDropped", activityTraceJson.length());
        }
        array.add(this.agentHealth.asJson());
        return array;
    }

    public void reset() {
        this.httpErrors.clear();
        this.httpTransactions.clear();
        this.activityTraces.clear();
        this.machineMeasurements.clear();
        this.agentHealth.clear();
    }

    public void setDataToken(DataToken dataToken) {
        if (dataToken == null) {
            return;
        }
        this.dataToken = dataToken;
    }

    public void setDeviceInformation(DeviceInformation deviceInformation) {
        this.deviceInformation = deviceInformation;
    }

    public void setHarvestTimeDelta(double harvestTimeDelta) {
        this.harvestTimeDelta = harvestTimeDelta;
    }

    public void setHttpTransactions(HttpTransactions httpTransactions) {
        this.httpTransactions = httpTransactions;
    }

    public void setMachineMeasurements(MachineMeasurements machineMeasurements) {
        this.machineMeasurements = machineMeasurements;
    }

    public void setActivityTraces(ActivityTraces activityTraces) {
        this.activityTraces = activityTraces;
    }

    public void setHttpErrors(HttpErrors httpErrors) {
        this.httpErrors = httpErrors;
    }

    public DeviceInformation getDeviceInformation() {
        return this.deviceInformation;
    }

    public HttpErrors getHttpErrors() {
        return this.httpErrors;
    }

    public HttpTransactions getHttpTransactions() {
        return this.httpTransactions;
    }

    public MachineMeasurements getMetrics() {
        return this.machineMeasurements;
    }

    public ActivityTraces getActivityTraces() {
        return this.activityTraces;
    }

    public AgentHealth getAgentHealth() {
        return this.agentHealth;
    }

    public DataToken getDataToken() {
        return this.dataToken;
    }

    public String toString() {
        return "HarvestData{dataToken=" + this.dataToken + ", deviceInformation=" + this.deviceInformation + ", harvestTimeDelta=" + this.harvestTimeDelta + ", httpTransactions=" + this.httpTransactions + ", machineMeasurements=" + this.machineMeasurements + ", httpErrors=" + this.httpErrors + ", activityTraces=" + this.activityTraces + '}';
    }
}

