/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.io;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteEvent;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListener;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListenerManager;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListenerSource;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class CountingInputStream
extends InputStream
implements StreamCompleteListenerSource {
    private final InputStream impl;
    private long count = 0L;
    private final StreamCompleteListenerManager listenerManager = new StreamCompleteListenerManager();
    private final ByteBuffer buffer;
    private boolean enableBuffering = false;
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public CountingInputStream(InputStream impl) {
        this.impl = impl;
        if (this.enableBuffering) {
            this.buffer = ByteBuffer.allocate(Agent.getResponseBodyLimit());
            this.fillBuffer();
        } else {
            this.buffer = null;
        }
    }

    public CountingInputStream(InputStream impl, boolean enableBuffering) {
        this.impl = impl;
        this.enableBuffering = enableBuffering;
        if (enableBuffering) {
            this.buffer = ByteBuffer.allocate(Agent.getResponseBodyLimit());
            this.fillBuffer();
        } else {
            this.buffer = null;
        }
    }

    @Override
    public void addStreamCompleteListener(StreamCompleteListener streamCompleteListener) {
        this.listenerManager.addStreamCompleteListener(streamCompleteListener);
    }

    @Override
    public void removeStreamCompleteListener(StreamCompleteListener streamCompleteListener) {
        this.listenerManager.removeStreamCompleteListener(streamCompleteListener);
    }

    @Override
    public int read() throws IOException {
        if (this.enableBuffering && this.bufferHasBytes(1L)) {
            int n = this.readBuffer();
            if (n >= 0) {
                ++this.count;
            }
            return n;
        }
        try {
            int n = this.impl.read();
            if (n >= 0) {
                ++this.count;
            } else {
                this.notifyStreamComplete();
            }
            return n;
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n = 0;
        int numBytesFromBuffer = 0;
        int inputBufferRemaining = b.length;
        if (this.enableBuffering) {
            if (this.bufferHasBytes(inputBufferRemaining)) {
                n = this.readBufferBytes(b);
                if (n >= 0) {
                    this.count += (long)n;
                } else {
                    throw new RuntimeException("readBufferBytes failed");
                }
                return n;
            }
            int remaining = this.buffer.remaining();
            if (remaining > 0) {
                numBytesFromBuffer = this.readBufferBytes(b, 0, remaining);
                if (numBytesFromBuffer < 0) {
                    throw new RuntimeException("partial read from buffer failed");
                }
                inputBufferRemaining -= numBytesFromBuffer;
                this.count += (long)numBytesFromBuffer;
            }
        }
        try {
            n = this.impl.read(b, numBytesFromBuffer, inputBufferRemaining);
            if (n >= 0) {
                this.count += (long)n;
                return n + numBytesFromBuffer;
            }
            if (numBytesFromBuffer <= 0) {
                this.notifyStreamComplete();
                return n;
            }
            return numBytesFromBuffer;
        }
        catch (IOException e) {
            log.error(e.toString());
            System.out.println("NOTIFY STREAM ERROR: " + e);
            e.printStackTrace();
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = 0;
        int numBytesFromBuffer = 0;
        int inputBufferRemaining = len;
        if (this.enableBuffering) {
            if (this.bufferHasBytes(inputBufferRemaining)) {
                n = this.readBufferBytes(b, off, len);
                if (n >= 0) {
                    this.count += (long)n;
                } else {
                    throw new RuntimeException("readBufferBytes failed");
                }
                return n;
            }
            int remaining = this.buffer.remaining();
            if (remaining > 0) {
                numBytesFromBuffer = this.readBufferBytes(b, off, remaining);
                if (numBytesFromBuffer < 0) {
                    throw new RuntimeException("partial read from buffer failed");
                }
                inputBufferRemaining -= numBytesFromBuffer;
                this.count += (long)numBytesFromBuffer;
            }
        }
        try {
            n = this.impl.read(b, off + numBytesFromBuffer, inputBufferRemaining);
            if (n >= 0) {
                this.count += (long)n;
                return n + numBytesFromBuffer;
            }
            if (numBytesFromBuffer <= 0) {
                this.notifyStreamComplete();
                return n;
            }
            return numBytesFromBuffer;
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public long skip(long byteCount) throws IOException {
        long toSkip = byteCount;
        if (this.enableBuffering) {
            if (this.bufferHasBytes(byteCount)) {
                this.buffer.position((int)byteCount);
                this.count += byteCount;
                return byteCount;
            }
            toSkip = byteCount - (long)this.buffer.remaining();
            if (toSkip > 0L) {
                this.buffer.position(this.buffer.remaining());
            } else {
                throw new RuntimeException("partial read from buffer (skip) failed");
            }
        }
        try {
            long n = this.impl.skip(toSkip);
            this.count += n;
            return n;
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        int remaining = 0;
        if (this.enableBuffering) {
            remaining = this.buffer.remaining();
        }
        try {
            return remaining + this.impl.available();
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.impl.close();
            this.notifyStreamComplete();
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public void mark(int readlimit) {
        if (!this.markSupported()) {
            return;
        }
        this.impl.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.impl.markSupported();
    }

    @Override
    public void reset() throws IOException {
        if (!this.markSupported()) {
            return;
        }
        try {
            this.impl.reset();
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    private int readBuffer() {
        if (this.bufferEmpty()) {
            return -1;
        }
        return this.buffer.get();
    }

    private int readBufferBytes(byte[] bytes) {
        return this.readBufferBytes(bytes, 0, bytes.length);
    }

    private int readBufferBytes(byte[] bytes, int offset, int length) {
        if (this.bufferEmpty()) {
            return -1;
        }
        int remainingBefore = this.buffer.remaining();
        this.buffer.get(bytes, offset, length);
        return remainingBefore - this.buffer.remaining();
    }

    private boolean bufferHasBytes(long num) {
        return (long)this.buffer.remaining() >= num;
    }

    private boolean bufferEmpty() {
        return !this.buffer.hasRemaining();
    }

    public void fillBuffer() {
        if (this.buffer != null) {
            if (!this.buffer.hasArray()) {
                return;
            }
            int bytesRead = 0;
            try {
                bytesRead = this.impl.read(this.buffer.array(), 0, this.buffer.capacity());
            }
            catch (IOException e) {
                log.error(e.toString());
            }
            if (bytesRead <= 0) {
                this.buffer.limit(0);
            } else if (bytesRead < this.buffer.capacity()) {
                this.buffer.limit(bytesRead);
            }
        }
    }

    private void notifyStreamComplete() {
        if (!this.listenerManager.isComplete()) {
            this.listenerManager.notifyStreamComplete(new StreamCompleteEvent(this, this.count));
        }
    }

    private void notifyStreamError(Exception e) {
        if (!this.listenerManager.isComplete()) {
            this.listenerManager.notifyStreamError(new StreamCompleteEvent(this, this.count, e));
        }
    }

    public void setBufferingEnabled(boolean enableBuffering) {
        this.enableBuffering = enableBuffering;
    }

    public String getBufferAsString() {
        if (this.buffer != null) {
            byte[] buf = new byte[this.buffer.limit()];
            for (int i = 0; i < this.buffer.limit(); ++i) {
                buf[i] = this.buffer.get(i);
            }
            return new String(buf);
        }
        return "";
    }
}

