/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement.producer;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.measurement.ThreadInfo;
import com.newrelic.agent.android.measurement.http.HttpErrorMeasurement;
import com.newrelic.agent.android.measurement.producer.BaseMeasurementProducer;
import com.newrelic.agent.android.util.Util;
import java.util.Map;

public class HttpErrorMeasurementProducer
extends BaseMeasurementProducer {
    public HttpErrorMeasurementProducer() {
        super(MeasurementType.HttpError);
    }

    public void produceMeasurement(String url, int statusCode) {
        this.produceMeasurement(url, statusCode, "");
    }

    public void produceMeasurement(String url, int statusCode, String responseBody) {
        this.produceMeasurement(url, statusCode, responseBody, null);
    }

    public void produceMeasurement(String url, int statusCode, String responseBody, Map<String, String> params) {
        this.produceMeasurement(url, statusCode, responseBody, params, new ThreadInfo());
    }

    public void produceMeasurement(String urlString, int statusCode, String responseBody, Map<String, String> params, ThreadInfo threadInfo) {
        String url = Util.sanitizeUrl(urlString);
        if (url == null) {
            return;
        }
        HttpErrorMeasurement measurement = new HttpErrorMeasurement(url, statusCode);
        measurement.setThreadInfo(threadInfo);
        measurement.setStackTrace(this.getSanitizedStackTrace());
        measurement.setResponseBody(responseBody);
        measurement.setParams(params);
        this.produceMeasurement(measurement);
    }

    private String getSanitizedStackTrace() {
        StringBuilder stackTrace = new StringBuilder();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int numErrors = 0;
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement frame = stackTraceElements[i];
            if (this.shouldFilterStackTraceElement(frame)) continue;
            stackTrace.append(frame.toString());
            if (i <= stackTraceElements.length - 1) {
                stackTrace.append("\n");
            }
            if (++numErrors >= Agent.getStackTraceLimit()) break;
        }
        return stackTrace.toString();
    }

    private boolean shouldFilterStackTraceElement(StackTraceElement element) {
        String className = element.getClassName();
        String method = element.getMethodName();
        if (className.startsWith("com.newrelic")) {
            return true;
        }
        if (className.startsWith("dalvik.system.VMStack") && method.startsWith("getThreadStackTrace")) {
            return true;
        }
        return className.startsWith("java.lang.Thread") && method.startsWith("getStackTrace");
    }
}

