/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonPrimitive;

public class ActivitySighting
extends HarvestableArray {
    private String name;
    private final long timestampMs;
    private long durationMs = 0L;

    public ActivitySighting(long timestampMs, String name) {
        this.timestampMs = timestampMs;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        ActivitySighting activitySighting = this;
        synchronized (activitySighting) {
            this.name = name;
        }
    }

    public long getTimestampMs() {
        return this.timestampMs;
    }

    public long getDuration() {
        return this.durationMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(long endTimestampMs) {
        ActivitySighting activitySighting = this;
        synchronized (activitySighting) {
            this.durationMs = endTimestampMs - this.timestampMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonArray asJsonArray() {
        JsonArray data = new JsonArray();
        ActivitySighting activitySighting = this;
        synchronized (activitySighting) {
            data.add(new JsonPrimitive(this.name));
            data.add(new JsonPrimitive(this.timestampMs));
            data.add(new JsonPrimitive(this.durationMs));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonArray asJsonArrayWithoutDuration() {
        JsonArray data = new JsonArray();
        ActivitySighting activitySighting = this;
        synchronized (activitySighting) {
            data.add(new JsonPrimitive(this.timestampMs));
            data.add(new JsonPrimitive(this.name));
        }
        return data;
    }

    public static ActivitySighting newFromJson(JsonArray jsonArray) {
        return new ActivitySighting(jsonArray.get(0).getAsLong(), jsonArray.get(1).getAsString());
    }
}

