/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest.crash;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.crashes.CrashReporter;
import com.newrelic.agent.android.harvest.ActivityHistory;
import com.newrelic.agent.android.harvest.DataToken;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.crash.ApplicationInfo;
import com.newrelic.agent.android.harvest.crash.DeviceInfo;
import com.newrelic.agent.android.harvest.crash.ExceptionInfo;
import com.newrelic.agent.android.harvest.crash.ThreadInfo;
import com.newrelic.agent.android.harvest.type.HarvestableObject;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.util.Util;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonParser;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.UUID;

public class Crash
extends HarvestableObject {
    public static final int PROTOCOL_VERSION = 1;
    private final UUID uuid;
    private final String buildId;
    private final long timestamp;
    private final String appToken;
    private DeviceInfo deviceInfo;
    private ApplicationInfo applicationInfo;
    private ExceptionInfo exceptionInfo;
    private List<ThreadInfo> threads;
    private ActivityHistory activityHistory;

    public Crash(UUID uuid, String buildId, long timestamp) {
        this.uuid = uuid;
        this.buildId = buildId;
        this.timestamp = timestamp;
        this.appToken = CrashReporter.getAgentConfiguration().getApplicationToken();
    }

    public Crash(Throwable throwable) {
        AgentImpl agentImpl = Agent.getImpl();
        Throwable cause = Crash.getRootCause(throwable);
        this.uuid = new UUID(Util.getRandom().nextLong(), Util.getRandom().nextLong());
        this.buildId = Crash.getBuildId();
        this.timestamp = System.currentTimeMillis() / 1000L;
        this.appToken = CrashReporter.getAgentConfiguration().getApplicationToken();
        this.deviceInfo = new DeviceInfo(agentImpl.getDeviceInformation(), agentImpl.getEnvironmentInformation());
        this.applicationInfo = new ApplicationInfo(agentImpl.getApplicationInformation());
        this.exceptionInfo = new ExceptionInfo(cause);
        this.threads = ThreadInfo.extractThreads(cause);
        this.activityHistory = TraceMachine.getActivityHistory();
    }

    public static String getBuildId() {
        return "";
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    @Override
    public JsonObject asJsonObject() {
        JsonObject data = new JsonObject();
        data.add("protocolVersion", new JsonPrimitive(1));
        data.add("platform", new JsonPrimitive("Android"));
        data.add("uuid", new JsonPrimitive(this.uuid.toString()));
        data.add("buildId", new JsonPrimitive(this.buildId));
        data.add("timestamp", new JsonPrimitive(this.timestamp));
        data.add("appToken", new JsonPrimitive(this.appToken));
        data.add("deviceInfo", this.deviceInfo.asJsonObject());
        data.add("appInfo", this.applicationInfo.asJsonObject());
        data.add("exception", this.exceptionInfo.asJsonObject());
        data.add("threads", this.getThreadsAsJson());
        data.add("activityHistory", this.activityHistory.asJsonArrayWithoutDuration());
        DataToken dataToken = Harvest.getHarvestConfiguration().getDataToken();
        if (dataToken != null) {
            data.add("dataToken", dataToken.asJsonArray());
        }
        return data;
    }

    public static Crash crashFromJsonString(String json) {
        JsonElement element = new JsonParser().parse(json);
        JsonObject crashObject = element.getAsJsonObject();
        String uuid = crashObject.get("uuid").getAsString();
        String buildIdentifier = crashObject.get("buildId").getAsString();
        long timestamp = crashObject.get("timestamp").getAsLong();
        Crash crash = new Crash(UUID.fromString(uuid), buildIdentifier, timestamp);
        crash.deviceInfo = DeviceInfo.newFromJson(crashObject.get("deviceInfo").getAsJsonObject());
        crash.applicationInfo = ApplicationInfo.newFromJson(crashObject.get("appInfo").getAsJsonObject());
        crash.exceptionInfo = ExceptionInfo.newFromJson(crashObject.get("exception").getAsJsonObject());
        crash.threads = ThreadInfo.newListFromJson(crashObject.get("threads").getAsJsonArray());
        crash.activityHistory = ActivityHistory.newFromJson(crashObject.get("activityHistory").getAsJsonArray());
        return crash;
    }

    private static Throwable getRootCause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return throwable;
        }
        return Crash.getRootCause(cause);
    }

    private JsonArray getThreadsAsJson() {
        JsonArray data = new JsonArray();
        for (ThreadInfo thread : this.threads) {
            data.add(thread.asJsonObject());
        }
        return data;
    }
}

