/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.io.CountingInputStream;
import com.newrelic.agent.android.instrumentation.io.CountingOutputStream;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteEvent;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListener;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class HttpsURLConnectionExtension
extends HttpsURLConnection {
    private HttpsURLConnection impl;
    private TransactionState transactionState;
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public HttpsURLConnectionExtension(HttpsURLConnection impl) {
        super(impl.getURL());
        this.impl = impl;
        TransactionStateUtil.setCrossProcessHeader(impl);
    }

    @Override
    public String getCipherSuite() {
        return this.impl.getCipherSuite();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.impl.getLocalCertificates();
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        try {
            return this.impl.getServerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            this.error(e);
            throw e;
        }
    }

    @Override
    public void addRequestProperty(String field, String newValue) {
        this.impl.addRequestProperty(field, newValue);
    }

    @Override
    public void disconnect() {
        if (this.transactionState != null && !this.transactionState.isComplete()) {
            this.addTransactionAndErrorData(this.transactionState);
        }
        this.impl.disconnect();
    }

    @Override
    public boolean usingProxy() {
        return this.impl.usingProxy();
    }

    @Override
    public void connect() throws IOException {
        this.getTransactionState();
        try {
            this.impl.connect();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.impl.getAllowUserInteraction();
    }

    @Override
    public int getConnectTimeout() {
        return this.impl.getConnectTimeout();
    }

    @Override
    public Object getContent() throws IOException {
        TransactionState transactionState;
        Object object;
        this.getTransactionState();
        try {
            object = this.impl.getContent();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        int contentLength = this.impl.getContentLength();
        if (contentLength >= 0 && !(transactionState = this.getTransactionState()).isComplete()) {
            transactionState.setBytesReceived(contentLength);
            this.addTransactionAndErrorData(transactionState);
        }
        return object;
    }

    public Object getContent(Class[] types) throws IOException {
        Object object;
        this.getTransactionState();
        try {
            object = this.impl.getContent(types);
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        this.checkResponse();
        return object;
    }

    @Override
    public String getContentEncoding() {
        this.getTransactionState();
        String contentEncoding = this.impl.getContentEncoding();
        this.checkResponse();
        return contentEncoding;
    }

    @Override
    public int getContentLength() {
        this.getTransactionState();
        int contentLength = this.impl.getContentLength();
        this.checkResponse();
        return contentLength;
    }

    @Override
    public String getContentType() {
        this.getTransactionState();
        String contentType = this.impl.getContentType();
        this.checkResponse();
        return contentType;
    }

    @Override
    public long getDate() {
        this.getTransactionState();
        long date = this.impl.getDate();
        this.checkResponse();
        return date;
    }

    @Override
    public InputStream getErrorStream() {
        CountingInputStream in;
        this.getTransactionState();
        try {
            in = new CountingInputStream(this.impl.getErrorStream(), true);
        }
        catch (Exception e) {
            log.error(e.toString());
            return this.impl.getErrorStream();
        }
        return in;
    }

    @Override
    public long getHeaderFieldDate(String field, long defaultValue) {
        this.getTransactionState();
        long date = this.impl.getHeaderFieldDate(field, defaultValue);
        this.checkResponse();
        return date;
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.impl.getInstanceFollowRedirects();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.impl.getPermission();
    }

    @Override
    public String getRequestMethod() {
        return this.impl.getRequestMethod();
    }

    @Override
    public int getResponseCode() throws IOException {
        int responseCode;
        this.getTransactionState();
        try {
            responseCode = this.impl.getResponseCode();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        this.checkResponse();
        return responseCode;
    }

    @Override
    public String getResponseMessage() throws IOException {
        String message;
        this.getTransactionState();
        try {
            message = this.impl.getResponseMessage();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        this.checkResponse();
        return message;
    }

    @Override
    public void setChunkedStreamingMode(int chunkLength) {
        this.impl.setChunkedStreamingMode(chunkLength);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.impl.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.impl.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        try {
            this.impl.setRequestMethod(method);
        }
        catch (ProtocolException e) {
            this.error(e);
            throw e;
        }
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.impl.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this.impl.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.impl.getDoOutput();
    }

    @Override
    public long getExpiration() {
        this.getTransactionState();
        long expiration = this.impl.getExpiration();
        this.checkResponse();
        return expiration;
    }

    @Override
    public String getHeaderField(int pos) {
        this.getTransactionState();
        String header = this.impl.getHeaderField(pos);
        this.checkResponse();
        return header;
    }

    @Override
    public String getHeaderField(String key) {
        this.getTransactionState();
        String header = this.impl.getHeaderField(key);
        this.checkResponse();
        return header;
    }

    @Override
    public int getHeaderFieldInt(String field, int defaultValue) {
        this.getTransactionState();
        int header = this.impl.getHeaderFieldInt(field, defaultValue);
        this.checkResponse();
        return header;
    }

    @Override
    public String getHeaderFieldKey(int posn) {
        this.getTransactionState();
        String key = this.impl.getHeaderFieldKey(posn);
        this.checkResponse();
        return key;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        this.getTransactionState();
        Map<String, List<String>> fields = this.impl.getHeaderFields();
        this.checkResponse();
        return fields;
    }

    @Override
    public long getIfModifiedSince() {
        this.getTransactionState();
        long ifModifiedSince = this.impl.getIfModifiedSince();
        this.checkResponse();
        return ifModifiedSince;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        CountingInputStream in;
        final TransactionState transactionState = this.getTransactionState();
        try {
            in = new CountingInputStream(this.impl.getInputStream());
            TransactionStateUtil.inspectAndInstrumentResponse(transactionState, this.impl);
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        in.addStreamCompleteListener(new StreamCompleteListener(){

            @Override
            public void streamError(StreamCompleteEvent e) {
                if (!transactionState.isComplete()) {
                    transactionState.setBytesReceived(e.getBytes());
                }
                HttpsURLConnectionExtension.this.error(e.getException());
            }

            @Override
            public void streamComplete(StreamCompleteEvent e) {
                if (!transactionState.isComplete()) {
                    long contentLength = HttpsURLConnectionExtension.this.impl.getContentLength();
                    long numBytes = e.getBytes();
                    if (contentLength >= 0L) {
                        numBytes = contentLength;
                    }
                    transactionState.setBytesReceived(numBytes);
                    HttpsURLConnectionExtension.this.addTransactionAndErrorData(transactionState);
                }
            }
        });
        return in;
    }

    @Override
    public long getLastModified() {
        this.getTransactionState();
        long lastModified = this.impl.getLastModified();
        this.checkResponse();
        return lastModified;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        CountingOutputStream out;
        final TransactionState transactionState = this.getTransactionState();
        try {
            out = new CountingOutputStream(this.impl.getOutputStream());
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        out.addStreamCompleteListener(new StreamCompleteListener(){

            @Override
            public void streamError(StreamCompleteEvent e) {
                if (!transactionState.isComplete()) {
                    transactionState.setBytesSent(e.getBytes());
                }
                HttpsURLConnectionExtension.this.error(e.getException());
            }

            @Override
            public void streamComplete(StreamCompleteEvent e) {
                if (!transactionState.isComplete()) {
                    String header = HttpsURLConnectionExtension.this.impl.getRequestProperty("content-length");
                    long numBytes = e.getBytes();
                    if (header != null) {
                        try {
                            numBytes = Long.parseLong(header);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                    transactionState.setBytesSent(numBytes);
                    HttpsURLConnectionExtension.this.addTransactionAndErrorData(transactionState);
                }
            }
        });
        return out;
    }

    @Override
    public int getReadTimeout() {
        return this.impl.getReadTimeout();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.impl.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String field) {
        return this.impl.getRequestProperty(field);
    }

    @Override
    public URL getURL() {
        return this.impl.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.impl.getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean newValue) {
        this.impl.setAllowUserInteraction(newValue);
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.impl.setConnectTimeout(timeoutMillis);
    }

    @Override
    public void setDefaultUseCaches(boolean newValue) {
        this.impl.setDefaultUseCaches(newValue);
    }

    @Override
    public void setDoInput(boolean newValue) {
        this.impl.setDoInput(newValue);
    }

    @Override
    public void setDoOutput(boolean newValue) {
        this.impl.setDoOutput(newValue);
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        this.impl.setIfModifiedSince(newValue);
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.impl.setReadTimeout(timeoutMillis);
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        this.impl.setRequestProperty(field, newValue);
    }

    @Override
    public void setUseCaches(boolean newValue) {
        this.impl.setUseCaches(newValue);
    }

    @Override
    public String toString() {
        return this.impl.toString();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return this.impl.getPeerPrincipal();
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.impl.getLocalPrincipal();
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.impl.setHostnameVerifier(hostnameVerifier);
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.impl.getHostnameVerifier();
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sf) {
        this.impl.setSSLSocketFactory(sf);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return this.impl.getSSLSocketFactory();
    }

    private void checkResponse() {
        if (!this.getTransactionState().isComplete()) {
            TransactionStateUtil.inspectAndInstrumentResponse(this.getTransactionState(), this.impl);
        }
    }

    private TransactionState getTransactionState() {
        if (this.transactionState == null) {
            this.transactionState = new TransactionState();
            TransactionStateUtil.inspectAndInstrument(this.transactionState, this.impl);
        }
        return this.transactionState;
    }

    private void error(Exception e) {
        TransactionState transactionState = this.getTransactionState();
        TransactionStateUtil.setErrorCodeFromException(transactionState, e);
        if (!transactionState.isComplete()) {
            TransactionStateUtil.inspectAndInstrumentResponse(transactionState, this.impl);
            TransactionData transactionData = transactionState.end();
            TaskQueue.queue(new HttpTransactionMeasurement(transactionData.getUrl(), transactionData.getStatusCode(), transactionData.getErrorCode(), transactionData.getTimestamp(), transactionData.getTime(), transactionData.getBytesSent(), transactionData.getBytesReceived(), transactionData.getAppData()));
        }
    }

    private void addTransactionAndErrorData(TransactionState transactionState) {
        TransactionData transactionData = transactionState.end();
        TaskQueue.queue(new HttpTransactionMeasurement(transactionData.getUrl(), transactionData.getStatusCode(), transactionData.getErrorCode(), transactionData.getTimestamp(), transactionData.getTime(), transactionData.getBytesSent(), transactionData.getBytesReceived(), transactionData.getAppData()));
        if ((long)transactionState.getStatusCode() >= 400L) {
            StringBuilder responseBody = new StringBuilder();
            try {
                InputStream errorStream = this.getErrorStream();
                if (errorStream instanceof CountingInputStream) {
                    responseBody.append(((CountingInputStream)errorStream).getBufferAsString());
                }
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            TreeMap<String, String> params = new TreeMap<String, String>();
            String contentType = this.impl.getContentType();
            if (contentType != null && !"".equals(contentType)) {
                params.put("content_type", contentType);
            }
            params.put("content_length", transactionState.getBytesReceived() + "");
            Measurements.addHttpError(transactionData, responseBody.toString(), params);
        }
    }
}

