/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement;

import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.Measurement;
import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.measurement.consumer.MeasurementConsumer;
import com.newrelic.agent.android.measurement.producer.BaseMeasurementProducer;
import com.newrelic.agent.android.measurement.producer.MeasurementProducer;
import java.util.ArrayList;
import java.util.Collection;

public class MeasurementPool
extends BaseMeasurementProducer
implements MeasurementConsumer {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final Collection<MeasurementProducer> producers = new ArrayList<MeasurementProducer>();
    private final Collection<MeasurementConsumer> consumers = new ArrayList<MeasurementConsumer>();

    public MeasurementPool() {
        super(MeasurementType.Any);
        this.addMeasurementProducer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeasurementProducer(MeasurementProducer producer) {
        Collection<MeasurementProducer> collection = this.producers;
        synchronized (collection) {
            if (this.producers.contains(producer)) {
                log.debug("Attempted to add the same MeasurementProducer " + producer + "  multiple times.");
                return;
            }
            this.producers.add(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMeasurementProducer(MeasurementProducer producer) {
        Collection<MeasurementProducer> collection = this.producers;
        synchronized (collection) {
            if (!this.producers.contains(producer)) {
                log.debug("Attempted to remove MeasurementProducer " + producer + " which is not registered.");
                return;
            }
            this.producers.remove(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeasurementConsumer(MeasurementConsumer consumer) {
        Collection<MeasurementConsumer> collection = this.consumers;
        synchronized (collection) {
            if (this.consumers.contains(consumer)) {
                log.debug("Attempted to add the same MeasurementConsumer " + consumer + " multiple times.");
                return;
            }
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMeasurementConsumer(MeasurementConsumer consumer) {
        Collection<MeasurementConsumer> collection = this.consumers;
        synchronized (collection) {
            if (!this.consumers.contains(consumer)) {
                log.debug("Attempted to remove MeasurementConsumer " + consumer + " which is not registered.");
                return;
            }
            this.consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastMeasurements() {
        Collection<Measurement> measurements;
        ArrayList<Measurement> allProducedMeasurements = new ArrayList<Measurement>();
        Collection<Object> collection = this.producers;
        synchronized (collection) {
            for (MeasurementProducer producer : this.producers) {
                measurements = producer.drainMeasurements();
                if (measurements.size() <= 0) continue;
                allProducedMeasurements.addAll(measurements);
            }
        }
        collection = this.consumers;
        synchronized (collection) {
            for (MeasurementConsumer consumer : this.consumers) {
                measurements = new ArrayList<Measurement>(allProducedMeasurements);
                for (Measurement measurement : measurements) {
                    if (consumer.getMeasurementType() != measurement.getType() && consumer.getMeasurementType() != MeasurementType.Any) continue;
                    consumer.consumeMeasurement(measurement);
                }
            }
        }
    }

    @Override
    public void consumeMeasurement(Measurement measurement) {
        this.produceMeasurement(measurement);
    }

    @Override
    public void consumeMeasurements(Collection<Measurement> measurements) {
        this.produceMeasurements(measurements);
    }

    @Override
    public MeasurementType getMeasurementType() {
        return MeasurementType.Any;
    }

    public Collection<MeasurementProducer> getMeasurementProducers() {
        return this.producers;
    }

    public Collection<MeasurementConsumer> getMeasurementConsumers() {
        return this.consumers;
    }
}

