/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.sample;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import android.os.Process;
import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.Sample;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.util.NamedThreadFactory;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sampler
implements TraceLifecycleAware,
Runnable {
    private static final long SAMPLE_FREQ_MS = 100L;
    private static final int[] PID = new int[]{Process.myPid()};
    private static final int KB_IN_MB = 1024;
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final ReentrantLock samplerLock = new ReentrantLock();
    private static Sampler sampler;
    private static boolean cpuSamplingDisabled;
    private final ActivityManager activityManager;
    private final EnumMap<Sample.SampleType, Collection<Sample>> samples = new EnumMap(Sample.SampleType.class);
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Sampler"));
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private ScheduledFuture sampleFuture;
    private Long lastCpuTime;
    private Long lastAppCpuTime;
    private RandomAccessFile procStatFile;
    private RandomAccessFile appStatFile;

    private Sampler(Context context) {
        this.activityManager = (ActivityManager)context.getSystemService("activity");
        this.samples.put(Sample.SampleType.MEMORY, new ArrayList());
        this.samples.put(Sample.SampleType.CPU, new ArrayList());
    }

    public static void init(Context context) {
        samplerLock.lock();
        sampler = new Sampler(context);
        samplerLock.unlock();
        TraceMachine.addTraceListener(sampler);
        log.debug("Sampler Initialized");
    }

    public static void start() {
        samplerLock.lock();
        if (sampler == null) {
            samplerLock.unlock();
            return;
        }
        sampler.schedule();
        samplerLock.unlock();
        log.debug("Sampler started");
    }

    public static void stop() {
        samplerLock.lock();
        if (sampler == null) {
            samplerLock.unlock();
            return;
        }
        sampler.stop(false);
        samplerLock.unlock();
    }

    public static void stopNow() {
        samplerLock.lock();
        if (sampler == null) {
            samplerLock.unlock();
            return;
        }
        sampler.stop(true);
        samplerLock.unlock();
    }

    public static void shutdown() {
        samplerLock.lock();
        if (sampler == null) {
            samplerLock.unlock();
            return;
        }
        TraceMachine.removeTraceListener(sampler);
        Sampler.stop();
        sampler = null;
        samplerLock.unlock();
    }

    @Override
    public void run() {
        try {
            if (this.isRunning.get()) {
                this.sample();
            }
        }
        catch (Exception e) {
            log.error("Caught exception while running the sampler", e);
            AgentHealth.noticeException(e);
        }
    }

    private void schedule() {
        if (this.isRunning.get()) {
            return;
        }
        this.clear();
        this.isRunning.set(true);
        this.sampleFuture = this.scheduler.scheduleAtFixedRate(this, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private void stop(boolean immediate) {
        samplerLock.lock();
        if (!this.isRunning.get()) {
            samplerLock.unlock();
            return;
        }
        this.isRunning.set(false);
        this.sampleFuture.cancel(immediate);
        this.resetCpuSampler();
        samplerLock.unlock();
        log.debug("Sampler stopped");
    }

    public static boolean isRunning() {
        if (sampler == null) {
            return false;
        }
        return !Sampler.sampler.sampleFuture.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sample() {
        samplerLock.lock();
        try {
            Sample cpuSample;
            Sample memorySample = Sampler.sampleMemory();
            if (memorySample != null) {
                this.getSampleCollection(Sample.SampleType.MEMORY).add(memorySample);
            }
            if ((cpuSample = this.sampleCpu()) != null) {
                this.getSampleCollection(Sample.SampleType.CPU).add(cpuSample);
            }
        }
        finally {
            samplerLock.unlock();
        }
    }

    private void clear() {
        for (Collection<Sample> sampleCollection : this.samples.values()) {
            sampleCollection.clear();
        }
    }

    public static Sample sampleMemory() {
        if (sampler == null) {
            return null;
        }
        return Sampler.sampleMemory(Sampler.sampler.activityManager);
    }

    public static Sample sampleMemory(ActivityManager activityManager) {
        Debug.MemoryInfo[] memInfo = activityManager.getProcessMemoryInfo(PID);
        int totalPss = memInfo[0].getTotalPss();
        if (totalPss >= 0) {
            Sample sample = new Sample(Sample.SampleType.MEMORY);
            sample.setSampleValue((double)totalPss / 1024.0);
            return sample;
        }
        return null;
    }

    public Sample sampleCpu() {
        if (cpuSamplingDisabled) {
            return null;
        }
        try {
            if (this.procStatFile == null || this.appStatFile == null) {
                this.procStatFile = new RandomAccessFile("/proc/stat", "r");
                this.appStatFile = new RandomAccessFile("/proc/" + PID[0] + "/stat", "r");
            } else {
                this.procStatFile.seek(0L);
                this.appStatFile.seek(0L);
            }
            String procStatString = this.procStatFile.readLine();
            String appStatString = this.appStatFile.readLine();
            String[] procStats = procStatString.split(" ");
            String[] appStats = appStatString.split(" ");
            long cpuTime = Long.parseLong(procStats[2]) + Long.parseLong(procStats[3]) + Long.parseLong(procStats[4]) + Long.parseLong(procStats[5]) + Long.parseLong(procStats[6]) + Long.parseLong(procStats[7]) + Long.parseLong(procStats[8]);
            long appTime = Long.parseLong(appStats[13]) + Long.parseLong(appStats[14]);
            if (this.lastCpuTime == null && this.lastAppCpuTime == null) {
                this.lastCpuTime = cpuTime;
                this.lastAppCpuTime = appTime;
                return null;
            }
            Sample sample = new Sample(Sample.SampleType.CPU);
            sample.setSampleValue((double)(appTime - this.lastAppCpuTime) / (double)(cpuTime - this.lastCpuTime) * 100.0);
            this.lastCpuTime = cpuTime;
            this.lastAppCpuTime = appTime;
            return sample;
        }
        catch (Exception e) {
            cpuSamplingDisabled = true;
            log.debug("Exception hit while CPU sampling: " + e.getMessage());
            AgentHealth.noticeException(e);
            return null;
        }
    }

    private void resetCpuSampler() {
        this.lastCpuTime = null;
        this.lastAppCpuTime = null;
        if (this.appStatFile != null && this.procStatFile != null) {
            try {
                this.appStatFile.close();
                this.procStatFile.close();
                this.appStatFile = null;
                this.procStatFile = null;
            }
            catch (IOException e) {
                log.debug("Exception hit while resetting CPU sampler: " + e.getMessage());
                AgentHealth.noticeException(e);
            }
        }
    }

    public static Map<Sample.SampleType, Collection<Sample>> copySamples() {
        samplerLock.lock();
        if (sampler == null) {
            samplerLock.unlock();
            return new HashMap<Sample.SampleType, Collection<Sample>>();
        }
        EnumMap<Sample.SampleType, Collection<Sample>> copy = new EnumMap<Sample.SampleType, Collection<Sample>>(Sampler.sampler.samples);
        for (Sample.SampleType key : Sampler.sampler.samples.keySet()) {
            copy.put(key, new ArrayList<Sample>(Sampler.sampler.samples.get((Object)key)));
        }
        samplerLock.unlock();
        return Collections.unmodifiableMap(copy);
    }

    private Collection<Sample> getSampleCollection(Sample.SampleType type) {
        return this.samples.get((Object)type);
    }

    @Override
    public void onEnterMethod() {
        if (this.isRunning.get()) {
            return;
        }
        Sampler.start();
    }

    @Override
    public void onExitMethod() {
    }

    @Override
    public void onTraceStart(ActivityTrace activityTrace) {
        Sampler.start();
    }

    @Override
    public void onTraceComplete(ActivityTrace activityTrace) {
        Sampler.stop();
        activityTrace.setVitals(Sampler.copySamples());
        this.clear();
    }

    static {
        cpuSamplingDisabled = false;
    }
}

