/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.text.MessageFormat;

public final class Carrier {
    private static final String ANDROID = "Android";
    private static AgentLog log = AgentLogManager.getAgentLog();

    public static String nameFromContext(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException e) {
            log.warning("Cannot determine network state. Enable android.permission.ACCESS_NETWORK_STATE in your manifest.");
            return "unknown";
        }
        if (networkInfo == null || !networkInfo.isConnected()) {
            return "none";
        }
        switch (networkInfo.getType()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Carrier.nameFromTelephonyManager(context);
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                return "wifi";
            }
        }
        log.warning(MessageFormat.format("Unknown network type: {0} [{1}]", networkInfo.getTypeName(), networkInfo.getType()));
        return "unknown";
    }

    private static String nameFromTelephonyManager(Context context) {
        boolean smellsLikeAnEmulator;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String networkOperator = telephonyManager.getNetworkOperatorName();
        boolean bl = smellsLikeAnEmulator = Build.PRODUCT.equals("google_sdk") || Build.PRODUCT.equals("sdk") || Build.PRODUCT.equals("sdk_x86") || Build.FINGERPRINT.startsWith("generic");
        if (networkOperator.equals(ANDROID) && smellsLikeAnEmulator) {
            return "wifi";
        }
        return networkOperator;
    }
}

