/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.analytics.AnalyticAttribute;
import com.newrelic.agent.android.analytics.AnalyticsController;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.analytics.AnalyticsEventFactory;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.analytics.EventManagerImpl;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.EnvironmentInformation;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class AnalyticsControllerImpl
implements AnalyticsController {
    private static final int MAX_ATTRIBUTES = 64;
    static final AgentLog log = AgentLogManager.getAgentLog();
    private Set<AnalyticAttribute> systemAttributes;
    private Set<AnalyticAttribute> userAttributes;
    private EventManager eventManager = new EventManagerImpl();
    private boolean isEnabled;
    private AgentImpl agentImpl;
    private AgentConfiguration agentConfiguration;
    private InteractionCompleteListener listener;
    private static final AnalyticsControllerImpl instance = new AnalyticsControllerImpl();
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final List<String> reservedNames = new ArrayList<String>();
    private static final String NEW_RELIC_PREFIX = "newRelic";
    private static final String NR_PREFIX = "nr.";

    public static void initialize(AgentConfiguration agentConfiguration, AgentImpl agentImpl) {
        log.debug("AnalyticsControllerImpl.initialize invoked.");
        if (!initialized.compareAndSet(false, true)) {
            log.debug("AnalyticsControllerImpl has already been initialized.  Bypassing..");
            return;
        }
        instance.clear();
        reservedNames.add("eventType");
        reservedNames.add("type");
        reservedNames.add("timestamp");
        reservedNames.add("category");
        reservedNames.add("accountId");
        reservedNames.add("appId");
        reservedNames.add("appName");
        reservedNames.add("uuid");
        reservedNames.add("sessionId");
        reservedNames.add("osName");
        reservedNames.add("osVersion");
        reservedNames.add("osMajorVersion");
        reservedNames.add("deviceManufacturer");
        reservedNames.add("deviceModel");
        reservedNames.add("memUsageMb");
        reservedNames.add("carrier");
        reservedNames.add("newRelicVersion");
        instance.reinitialize(agentConfiguration, agentImpl);
        TraceMachine.addTraceListener(AnalyticsControllerImpl.instance.listener);
        log.info("Analytics Controller started.");
    }

    public static void shutdown() {
        TraceMachine.removeTraceListener(AnalyticsControllerImpl.instance.listener);
        initialized.compareAndSet(true, false);
        instance.getEventManager().shutdown();
    }

    private AnalyticsControllerImpl() {
        this.systemAttributes = Collections.synchronizedSet(new HashSet());
        this.userAttributes = Collections.synchronizedSet(new HashSet());
        this.listener = new InteractionCompleteListener();
    }

    void reinitialize(AgentConfiguration agentConfiguration, AgentImpl agentImpl) {
        this.agentImpl = agentImpl;
        this.agentConfiguration = agentConfiguration;
        this.eventManager.initialize();
        this.isEnabled = agentConfiguration.getEnableAnalyticsEvents();
        this.loadPersistentAttributes();
        this.removeAttribute("sessionDuration");
        DeviceInformation deviceInformation = agentImpl.getDeviceInformation();
        String osVersion = deviceInformation.getOsVersion();
        String osMajorVersion = osVersion.substring(0, osVersion.indexOf("."));
        EnvironmentInformation environmentInformation = agentImpl.getEnvironmentInformation();
        this.systemAttributes.add(new AnalyticAttribute("osName", deviceInformation.getOsName()));
        this.systemAttributes.add(new AnalyticAttribute("osVersion", osVersion));
        this.systemAttributes.add(new AnalyticAttribute("osMajorVersion", osMajorVersion));
        this.systemAttributes.add(new AnalyticAttribute("deviceManufacturer", deviceInformation.getManufacturer()));
        this.systemAttributes.add(new AnalyticAttribute("deviceModel", deviceInformation.getModel()));
        this.systemAttributes.add(new AnalyticAttribute("uuid", deviceInformation.getDeviceId()));
        this.systemAttributes.add(new AnalyticAttribute("carrier", agentImpl.getNetworkCarrier()));
        this.systemAttributes.add(new AnalyticAttribute("newRelicVersion", deviceInformation.getAgentVersion()));
        this.systemAttributes.add(new AnalyticAttribute("memUsageMb", environmentInformation.getMemoryUsage()));
        this.systemAttributes.add(new AnalyticAttribute("sessionId", agentConfiguration.getSessionID()));
    }

    @Override
    public AnalyticAttribute getAttribute(String name) {
        log.debug("AnalyticsControllerImpl.getAttribute - retrieving " + name);
        AnalyticAttribute attribute = this.getUserAttribute(name);
        if (attribute == null) {
            attribute = this.getSystemAttribute(name);
        }
        return attribute;
    }

    @Override
    public Set<AnalyticAttribute> getSystemAttributes() {
        HashSet<AnalyticAttribute> attrs = new HashSet<AnalyticAttribute>(this.systemAttributes.size());
        for (AnalyticAttribute attr : this.systemAttributes) {
            attrs.add(new AnalyticAttribute(attr));
        }
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public Set<AnalyticAttribute> getUserAttributes() {
        HashSet<AnalyticAttribute> attrs = new HashSet<AnalyticAttribute>(this.userAttributes.size());
        for (AnalyticAttribute attr : this.userAttributes) {
            attrs.add(new AnalyticAttribute(attr));
        }
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public Set<AnalyticAttribute> getSessionAttributes() {
        HashSet<AnalyticAttribute> attrs = new HashSet<AnalyticAttribute>(this.userAttributes.size());
        attrs.addAll(this.getSystemAttributes());
        attrs.addAll(this.getUserAttributes());
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public int getSystemAttributeCount() {
        return this.systemAttributes.size();
    }

    @Override
    public int getUserAttributeCount() {
        return this.userAttributes.size();
    }

    @Override
    public int getTotalAttributeCount() {
        return this.systemAttributes.size() + this.userAttributes.size();
    }

    @Override
    public boolean setAttribute(String name, String value) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value);
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, String value, boolean persistent) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        if (!this.isNameValid(name) || !this.isStringValueValid(name, value)) {
            return false;
        }
        AnalyticAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            if (this.userAttributes.size() < 64) {
                boolean stored;
                attribute = new AnalyticAttribute(name, value, true);
                this.userAttributes.add(attribute);
                if (persistent && !(stored = this.agentConfiguration.getAnalyticAttributeStore().store(attribute))) {
                    log.error("Failed to store attribute " + attribute + " to attribute store.");
                    return stored;
                }
            } else {
                log.warning("Attribute limit exceeded: at most 64 are allowed.");
                log.warning("Currently defined attributes:");
                for (AnalyticAttribute attr : this.userAttributes) {
                    log.warning("\t" + attr.getName() + ": " + (attr.isStringAttribute() ? attr.getStringValue() : Float.valueOf(attr.getFloatValue())));
                }
            }
        } else {
            attribute.setStringValue(value);
            attribute.setPersistent(persistent);
            if (attribute.isPersistent()) {
                boolean stored = this.agentConfiguration.getAnalyticAttributeStore().store(attribute);
                if (!stored) {
                    log.error("Failed to store attribute " + attribute + " to attribute store.");
                    return stored;
                }
            } else {
                this.agentConfiguration.getAnalyticAttributeStore().delete(attribute);
            }
        }
        return true;
    }

    @Override
    public boolean setAttribute(String name, float value) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value);
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, float value, boolean persistent) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        if (!this.isNameValid(name)) {
            return false;
        }
        AnalyticAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            if (this.userAttributes.size() < 64) {
                attribute = new AnalyticAttribute(name, value, true);
                this.userAttributes.add(attribute);
                if (persistent) {
                    this.agentConfiguration.getAnalyticAttributeStore().store(attribute);
                    boolean stored = this.agentConfiguration.getAnalyticAttributeStore().store(attribute);
                    if (!stored) {
                        log.error("Failed to store attribute " + attribute + " to attribute store.");
                        return stored;
                    }
                }
            } else {
                log.warning("Attribute limit exceeded: at most 64 are allowed.");
                log.warning("Currently defined attributes:");
                for (AnalyticAttribute attr : this.userAttributes) {
                    log.warning("\t" + attr.getName() + ": " + (attr.isStringAttribute() ? attr.getStringValue() : Float.valueOf(attr.getFloatValue())));
                }
            }
        } else {
            attribute.setFloatValue(value);
            attribute.setPersistent(persistent);
            if (attribute.isPersistent()) {
                boolean stored = this.agentConfiguration.getAnalyticAttributeStore().store(attribute);
                if (!stored) {
                    log.error("Failed to store attribute " + attribute + " to attribute store.");
                    return stored;
                }
            } else {
                this.agentConfiguration.getAnalyticAttributeStore().delete(attribute);
            }
        }
        return true;
    }

    @Override
    public boolean incrementAttribute(String name, float value) {
        log.debug("AnalyticsControllerImpl.incrementAttribute - " + name + ": " + value);
        return this.incrementAttribute(name, value, true);
    }

    @Override
    public boolean incrementAttribute(String name, float value, boolean persistent) {
        log.debug("AnalyticsControllerImpl.incrementAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        if (!this.isNameValid(name)) {
            return false;
        }
        AnalyticAttribute attribute = this.getAttribute(name);
        if (attribute != null && !attribute.isStringAttribute()) {
            boolean stored;
            attribute.setFloatValue(attribute.getFloatValue() + value);
            attribute.setPersistent(persistent);
            if (attribute.isPersistent() && !(stored = this.agentConfiguration.getAnalyticAttributeStore().store(attribute))) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return stored;
            }
        } else if (attribute == null) {
            if (this.userAttributes.size() < 64) {
                attribute = new AnalyticAttribute(name, value, persistent);
                this.userAttributes.add(attribute);
                if (attribute.isPersistent()) {
                    this.agentConfiguration.getAnalyticAttributeStore().store(attribute);
                    boolean stored = this.agentConfiguration.getAnalyticAttributeStore().store(attribute);
                    if (!stored) {
                        log.error("Failed to store attribute " + attribute + " to attribute store.");
                        return stored;
                    }
                } else {
                    this.agentConfiguration.getAnalyticAttributeStore().delete(attribute);
                }
            }
        } else {
            log.warning("Cannot increment attribute " + name + ": the attribute is already defined as a String value.");
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAttribute(String name) {
        log.debug("AnalyticsControllerImpl.removeAttribute - " + name);
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        AnalyticAttribute attribute = this.getAttribute(name);
        if (attribute != null) {
            this.userAttributes.remove(attribute);
            if (attribute.isPersistent()) {
                this.agentConfiguration.getAnalyticAttributeStore().delete(attribute);
            }
        }
        return true;
    }

    @Override
    public boolean removeAllAttributes() {
        log.debug("AnalyticsControllerImpl.removeAttributes - ");
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        this.agentConfiguration.getAnalyticAttributeStore().clear();
        this.userAttributes.clear();
        return false;
    }

    @Override
    public boolean addEvent(String name, Set<AnalyticAttribute> eventAttributes) {
        return this.addEvent(name, AnalyticsEventCategory.Custom, "Mobile", eventAttributes);
    }

    @Override
    public boolean addEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Set<AnalyticAttribute> eventAttributes) {
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        log.debug("AnalyticsControllerImpl.addEvent - " + name + ": category=" + (Object)((Object)eventCategory) + ", eventType: " + eventType + ", eventAttributes:" + eventAttributes);
        HashSet<AnalyticAttribute> validatedAttributes = new HashSet<AnalyticAttribute>();
        for (AnalyticAttribute attribute : eventAttributes) {
            if (this.isNameReserved(attribute.getName())) {
                log.warning("Attribute name " + attribute.getName() + " is reserved for internal use and will be ignored.");
                continue;
            }
            validatedAttributes.add(attribute);
        }
        AnalyticsEvent event = AnalyticsEventFactory.createEvent(name, eventCategory, eventType, validatedAttributes);
        return this.addEvent(event);
    }

    @Override
    public boolean addEvent(AnalyticsEvent event) {
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        HashSet<AnalyticAttribute> sessionAttributes = new HashSet<AnalyticAttribute>();
        sessionAttributes.add(new AnalyticAttribute("timeSinceLoad", (float)this.agentImpl.getSessionDurationMillis() / 1000.0f));
        event.addAttributes(sessionAttributes);
        return this.eventManager.addEvent(event);
    }

    @Override
    public int getMaxEventPoolSize() {
        return this.eventManager.getMaxEventPoolSize();
    }

    @Override
    public void setMaxEventPoolSize(int maxSize) {
        this.eventManager.setMaxEventPoolSize(maxSize);
    }

    @Override
    public void setMaxEventBufferTime(int maxBufferTimeInSec) {
        this.eventManager.setMaxEventBufferTime(maxBufferTimeInSec);
    }

    @Override
    public int getMaxEventBufferTime() {
        return this.eventManager.getMaxEventBufferTime();
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    public static AnalyticsControllerImpl getInstance() {
        return instance;
    }

    void loadPersistentAttributes() {
        log.debug("AnalyticsControllerImpl.loadPersistentAttributes - loading userAttributes from the attribute store...");
        List<AnalyticAttribute> storedAttrs = this.agentConfiguration.getAnalyticAttributeStore().fetchAll();
        log.debug("AnalyticsControllerImpl.loadPersistentAttributes - found " + storedAttrs.size() + " userAttributes in the attribute store...");
        for (AnalyticAttribute attr : storedAttrs) {
            this.userAttributes.add(attr);
        }
    }

    private AnalyticAttribute getSystemAttribute(String name) {
        AnalyticAttribute attribute = null;
        for (AnalyticAttribute nextAttribute : this.systemAttributes) {
            if (!nextAttribute.getName().equals(name)) continue;
            attribute = nextAttribute;
            break;
        }
        return attribute;
    }

    private AnalyticAttribute getUserAttribute(String name) {
        AnalyticAttribute attribute = null;
        for (AnalyticAttribute nextAttribute : this.userAttributes) {
            if (!nextAttribute.getName().equals(name)) continue;
            attribute = nextAttribute;
            break;
        }
        return attribute;
    }

    private void clear() {
        log.debug("AnalyticsControllerImpl.clear - clearing out attributes and events");
        this.systemAttributes.clear();
        this.userAttributes.clear();
        this.eventManager.empty();
    }

    private boolean isNameValid(String name) {
        boolean valid;
        boolean bl = valid = name != null && !name.equals("") && name.length() < 256;
        if (!valid) {
            log.error("Attribute name " + name + " is null, empty, or exceeds the maximum length of " + 256 + " characters.");
        } else {
            boolean bl2 = valid = !this.isNameReserved(name);
            if (!valid) {
                log.error("Attribute name " + name + " is reserved for internal use.");
            }
        }
        return valid;
    }

    private boolean isStringValueValid(String name, String value) {
        boolean valid;
        boolean bl = valid = value != null && !value.equals("") && value.getBytes().length < 4096;
        if (!valid) {
            log.error("Attribute value for name " + name + " is null, empty, or exceeds the maximum length of " + 4096 + " bytes.");
        }
        return valid;
    }

    private boolean isNameReserved(String name) {
        boolean isReserved = reservedNames.contains(name);
        if (isReserved) {
            log.debug("Name " + name + " is in the reserved names list.");
            return isReserved;
        }
        boolean bl = isReserved = isReserved || name.startsWith(NEW_RELIC_PREFIX);
        if (isReserved) {
            log.debug("Name " + name + " starts with reserved prefix " + NEW_RELIC_PREFIX);
            return isReserved;
        }
        boolean bl2 = isReserved = isReserved || name.startsWith(NR_PREFIX);
        if (isReserved) {
            log.debug("Name " + name + " starts with reserved prefix " + NR_PREFIX);
        }
        return isReserved;
    }

    @Override
    public boolean recordEvent(String name, Map<String, Object> eventAttributes) {
        log.debug("AnalyticsControllerImpl.recordEvent - " + name + ": " + eventAttributes.size() + " attributes");
        HashSet<AnalyticAttribute> attributes = new HashSet<AnalyticAttribute>();
        try {
            for (String key : eventAttributes.keySet()) {
                Object value = eventAttributes.get(key);
                try {
                    if (value instanceof String) {
                        attributes.add(new AnalyticAttribute(key, (String)value));
                        continue;
                    }
                    if (value instanceof Float) {
                        attributes.add(new AnalyticAttribute(key, Float.valueOf(((Float)value).floatValue()).floatValue()));
                        continue;
                    }
                    if (value instanceof Double) {
                        attributes.add(new AnalyticAttribute(key, Float.valueOf(((Double)value).floatValue()).floatValue()));
                        continue;
                    }
                    if (value instanceof Integer) {
                        attributes.add(new AnalyticAttribute(key, Float.valueOf(((Integer)value).intValue()).floatValue()));
                        continue;
                    }
                    if (value instanceof Short) {
                        attributes.add(new AnalyticAttribute(key, Float.valueOf(((Short)value).shortValue()).floatValue()));
                        continue;
                    }
                    if (value instanceof Long) {
                        attributes.add(new AnalyticAttribute(key, Float.valueOf(((Long)value).longValue()).floatValue()));
                        continue;
                    }
                    if (value instanceof BigDecimal) {
                        attributes.add(new AnalyticAttribute(key, Float.valueOf(((BigDecimal)value).floatValue()).floatValue()));
                        continue;
                    }
                    if (value instanceof BigInteger) {
                        attributes.add(new AnalyticAttribute(key, Float.valueOf(((BigInteger)value).floatValue()).floatValue()));
                        continue;
                    }
                    log.error("Unsupported event attribute type for key [" + key + "]: " + value.getClass().getName());
                    return false;
                }
                catch (ClassCastException e) {
                    log.error(String.format("Error casting attribute [%s] to String or Float: ", key), e);
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", name), e);
        }
        return this.addEvent(name, AnalyticsEventCategory.Custom, "Mobile", attributes);
    }

    class InteractionCompleteListener
    implements TraceLifecycleAware {
        InteractionCompleteListener() {
        }

        @Override
        public void onEnterMethod() {
        }

        @Override
        public void onExitMethod() {
        }

        @Override
        public void onTraceStart(ActivityTrace activityTrace) {
        }

        @Override
        public void onTraceComplete(ActivityTrace activityTrace) {
            log.debug("AnalyticsControllerImpl.InteractionCompleteListener.onTraceComplete invoke.");
            float durationInSec = (float)activityTrace.rootTrace.getDuration() / 1000.0f;
            HashSet<AnalyticAttribute> attrs = new HashSet<AnalyticAttribute>();
            attrs.add(new AnalyticAttribute("interactionDuration", durationInSec));
            AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
            analyticsController.addEvent(activityTrace.rootTrace.displayName, AnalyticsEventCategory.Interaction, "Mobile", attrs);
        }
    }
}

