/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.crashes;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.crashes.CrashStore;
import com.newrelic.agent.android.harvest.crash.Crash;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stats.TicToc;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class CrashReporter {
    private static final String CRASH_COLLECTOR_PATH = "/mobile_crash";
    private static final int CRASH_COLLECTOR_TIMEOUT = 5000;
    private static final CrashReporter instance = new CrashReporter();
    private static AgentConfiguration agentConfiguration;
    private final AgentLog log = AgentLogManager.getAgentLog();
    private boolean isEnabled = false;
    private boolean reportCrashes = true;
    private Thread.UncaughtExceptionHandler previousExceptionHandler;
    private CrashStore crashStore;
    private static final AtomicBoolean initialized;

    public static void initialize(AgentConfiguration _agentConfiguration) {
        if (!initialized.compareAndSet(false, true)) {
            return;
        }
        agentConfiguration = _agentConfiguration;
        CrashReporter.instance.isEnabled = agentConfiguration.getReportCrashes();
        CrashReporter.instance.crashStore = agentConfiguration.getCrashStore();
        instance.reportSavedCrashes();
        if (CrashReporter.instance.isEnabled) {
            instance.installCrashHandler();
        }
    }

    public static AgentConfiguration getAgentConfiguration() {
        return agentConfiguration;
    }

    public UncaughtExceptionHandler getHandler() {
        return new UncaughtExceptionHandler();
    }

    public static UncaughtExceptionHandler getInstanceHandler() {
        return instance.getHandler();
    }

    public static void setReportCrashes(boolean reportCrashes) {
        CrashReporter.instance.reportCrashes = reportCrashes;
    }

    public static int storedCrashes() {
        return CrashReporter.instance.crashStore.count();
    }

    public static List<Crash> fetchAllCrashes() {
        return CrashReporter.instance.crashStore.fetchAll();
    }

    public static void clear() {
        CrashReporter.instance.crashStore.clear();
    }

    private void installCrashHandler() {
        Thread.UncaughtExceptionHandler currentExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentExceptionHandler != null) {
            if (currentExceptionHandler instanceof UncaughtExceptionHandler) {
                this.log.debug("New Relic crash handler already installed.");
                return;
            }
            this.previousExceptionHandler = currentExceptionHandler;
            this.log.debug("Installing New Relic crash handler and chaining " + this.previousExceptionHandler.getClass().getName() + ".");
        } else {
            this.log.debug("Installing New Relic crash handler.");
        }
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler());
    }

    public static void resetForTesting() {
        initialized.compareAndSet(true, false);
    }

    private void reportSavedCrashes() {
        for (Crash crash : this.crashStore.fetchAll()) {
            this.reportCrash(crash, false);
        }
    }

    private void reportCrash(Crash crash, boolean block) {
        this.crashStore.store(crash);
        if (this.reportCrashes) {
            CrashSender sender = new CrashSender(crash);
            Thread senderThread = new Thread(sender);
            senderThread.start();
            if (block) {
                try {
                    senderThread.join();
                }
                catch (InterruptedException e) {
                    this.log.error("Exception caught while waiting to send crash", e);
                }
            }
        }
    }

    static {
        initialized = new AtomicBoolean(false);
    }

    private class CrashSender
    implements Runnable {
        private final Crash crash;

        CrashSender(Crash crash) {
            this.crash = crash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String protocol = agentConfiguration.useSsl() ? "https://" : "http://";
                String urlString = protocol + agentConfiguration.getCrashCollectorHost() + CrashReporter.CRASH_COLLECTOR_PATH;
                URL url = new URL(urlString);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(true);
                connection.setChunkedStreamingMode(0);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setConnectTimeout(5000);
                try {
                    BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
                    ((OutputStream)out).write(this.crash.toJsonString().getBytes());
                    ((OutputStream)out).close();
                    if (connection.getResponseCode() == 200) {
                        CrashReporter.this.log.info("Crash " + this.crash.getUuid().toString() + " successfully submitted.");
                        CrashReporter.this.crashStore.delete(this.crash);
                    } else {
                        CrashReporter.this.log.error("Something went wrong while submitting a crash (will try again later) - Response code " + connection.getResponseCode());
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                CrashReporter.this.log.error("Unable to report crash to New Relic, will try again later.", e);
            }
        }
    }

    private class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicBoolean handledException = new AtomicBoolean(false);

        private UncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (!this.handledException.compareAndSet(false, true)) {
                StatsEngine.get().inc("Supportability/AgentHealth/Recursion/UncaughtExceptionHandler");
                return;
            }
            try {
                if (!instance.isEnabled || !FeatureFlag.featureEnabled(FeatureFlag.CrashReporting)) {
                    CrashReporter.this.log.debug("A crash has been detected but crash reporting is disabled!");
                    this.chainExceptionHandler(thread, throwable);
                    return;
                }
                TicToc timer = new TicToc();
                timer.tic();
                CrashReporter.this.log.debug("A crash has been detected in " + thread.getStackTrace()[0].getClassName() + " and will be reported ASAP.");
                CrashReporter.this.log.debug("Analytics data is currently " + (agentConfiguration.getEnableAnalyticsEvents() ? "enabled " : "disabled"));
                Crash crash = new Crash(throwable, AnalyticsControllerImpl.getInstance().getSessionAttributes(), AnalyticsControllerImpl.getInstance().getEventManager().getQueuedEvents(), agentConfiguration.getEnableAnalyticsEvents());
                CrashReporter.this.reportCrash(crash, true);
                CrashReporter.this.log.debug("Crash collection took " + timer.toc() + "ms");
                this.chainExceptionHandler(thread, throwable);
            }
            catch (Throwable t) {
                CrashReporter.this.log.error("Error encountered while preparing crash for New Relic!", t);
                this.chainExceptionHandler(thread, throwable);
            }
        }

        private void chainExceptionHandler(Thread thread, Throwable throwable) {
            if (CrashReporter.this.previousExceptionHandler != null) {
                CrashReporter.this.log.debug("Chaining crash reporting duties to " + CrashReporter.this.previousExceptionHandler.getClass().getSimpleName());
                CrashReporter.this.previousExceptionHandler.uncaughtException(thread, throwable);
            }
        }
    }
}

