/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement.producer;

import com.newrelic.agent.android.measurement.Measurement;
import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.measurement.producer.MeasurementProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class BaseMeasurementProducer
implements MeasurementProducer {
    private final MeasurementType producedMeasurementType;
    private final ArrayList<Measurement> producedMeasurements = new ArrayList();

    public BaseMeasurementProducer(MeasurementType measurementType) {
        this.producedMeasurementType = measurementType;
    }

    @Override
    public MeasurementType getMeasurementType() {
        return this.producedMeasurementType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceMeasurement(Measurement measurement) {
        ArrayList<Measurement> arrayList = this.producedMeasurements;
        synchronized (arrayList) {
            if (measurement != null) {
                this.producedMeasurements.add(measurement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceMeasurements(Collection<Measurement> measurements) {
        ArrayList<Measurement> arrayList = this.producedMeasurements;
        synchronized (arrayList) {
            if (measurements != null) {
                this.producedMeasurements.addAll(measurements);
                while (this.producedMeasurements.remove(null)) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Measurement> drainMeasurements() {
        ArrayList<Measurement> arrayList = this.producedMeasurements;
        synchronized (arrayList) {
            if (this.producedMeasurements.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<Measurement> measurements = new ArrayList<Measurement>(this.producedMeasurements);
            this.producedMeasurements.clear();
            return measurements;
        }
    }
}

