/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class EventManagerImpl
implements EventManager {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    public static int DEFAULT_MAX_EVENT_BUFFER_TIME = 600;
    public static int DEFAULT_MAX_EVENT_BUFFER_SIZE = 1000;
    private List<AnalyticsEvent> events;
    private int maxEventPoolSize;
    private int maxBufferTimeInSec;
    private long firstEventTimestamp;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicInteger eventsRecorded = new AtomicInteger(0);
    private AtomicInteger eventsEjected = new AtomicInteger(0);

    public EventManagerImpl() {
        this(DEFAULT_MAX_EVENT_BUFFER_SIZE, DEFAULT_MAX_EVENT_BUFFER_TIME);
    }

    public EventManagerImpl(int maxEventPoolSize, int maxBufferTimeInSec) {
        this.events = Collections.synchronizedList(new ArrayList(maxEventPoolSize));
        this.maxBufferTimeInSec = maxBufferTimeInSec;
        this.maxEventPoolSize = maxEventPoolSize;
        this.firstEventTimestamp = 0L;
        this.eventsRecorded.set(0);
        this.eventsEjected.set(0);
    }

    @Override
    public void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            log.debug("EventManagerImpl has already been initialized.  Bypassing...");
            return;
        }
        this.firstEventTimestamp = 0L;
        this.eventsRecorded.set(0);
        this.eventsEjected.set(0);
        this.empty();
    }

    @Override
    public void shutdown() {
        this.initialized.set(false);
    }

    @Override
    public int size() {
        return this.events.size();
    }

    @Override
    public void empty() {
        this.events.clear();
    }

    @Override
    public boolean isTransmitRequired() {
        log.debug("EventManagerImpl.isTransmitRequired: initialized: " + this.initialized.get());
        log.debug("EventManagerImpl.isTransmitRequired: buffer size: " + this.events.size());
        return !this.initialized.get() && this.events.size() > 0 || this.isMaxEventBufferTimeExceeded();
    }

    @Override
    public boolean addEvent(AnalyticsEvent event) {
        int eventsRecorded = this.eventsRecorded.incrementAndGet();
        if (this.events.size() == 0) {
            log.debug("EventManagerImpl.addEvent - Queue is currently empty, setting to first event timestamp to " + System.currentTimeMillis());
            this.firstEventTimestamp = System.currentTimeMillis();
        }
        if (this.events.size() >= this.maxEventPoolSize) {
            this.eventsEjected.incrementAndGet();
            int index = (int)(Math.random() * (double)eventsRecorded);
            if (index >= this.maxEventPoolSize) {
                return true;
            }
            this.events.remove(index);
        }
        return this.events.add(event);
    }

    @Override
    public int getEventsRecorded() {
        return this.eventsRecorded.get();
    }

    @Override
    public int getEventsEjected() {
        return this.eventsEjected.get();
    }

    @Override
    public boolean isMaxEventBufferTimeExceeded() {
        log.debug("EventManagerImpl.isMaxEventBufferTimeExceeded invoked.  maxBufferTimeInSec: " + this.maxBufferTimeInSec + ", firstEventTimestamp: " + this.firstEventTimestamp + ", current timestamp: " + System.currentTimeMillis() + ", delta: " + (System.currentTimeMillis() - this.firstEventTimestamp));
        if (this.firstEventTimestamp > 0L) {
            return System.currentTimeMillis() - this.firstEventTimestamp > (long)(this.maxBufferTimeInSec * 1000);
        }
        return false;
    }

    @Override
    public boolean isMaxEventPoolSizeExceeded() {
        log.debug("EventManagerImpl.isMaxEventBufferSizeExceeded invoked.  maxEventPoolSize: " + this.maxEventPoolSize + ", current pool size: " + this.events.size());
        return this.events.size() > this.maxEventPoolSize;
    }

    @Override
    public int getMaxEventPoolSize() {
        return this.maxEventPoolSize;
    }

    @Override
    public void setMaxEventPoolSize(int maxSize) {
        this.maxEventPoolSize = maxSize;
    }

    @Override
    public void setMaxEventBufferTime(int maxBufferTimeInSec) {
        this.maxBufferTimeInSec = maxBufferTimeInSec;
    }

    @Override
    public int getMaxEventBufferTime() {
        return this.maxBufferTimeInSec;
    }

    @Override
    public Collection<AnalyticsEvent> getQueuedEvents() {
        return Collections.unmodifiableCollection(this.events);
    }
}

