/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.harvest.ActivityTraces;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.harvest.HarvestData;
import com.newrelic.agent.android.harvest.MachineMeasurements;
import com.newrelic.agent.android.metric.Metric;
import com.newrelic.agent.android.tracing.ActivityTrace;
import java.util.List;

public class HarvestDataValidator
extends HarvestAdapter {
    @Override
    public void onHarvestFinalize() {
        if (!Harvest.isInitialized()) {
            return;
        }
        this.ensureActivityNameMetricsExist();
    }

    public void ensureActivityNameMetricsExist() {
        HarvestData harvestData = Harvest.getInstance().getHarvestData();
        ActivityTraces activityTraces = harvestData.getActivityTraces();
        if (activityTraces == null || activityTraces.count() == 0) {
            return;
        }
        MachineMeasurements metrics = harvestData.getMetrics();
        if (metrics == null || metrics.isEmpty()) {
            return;
        }
        for (ActivityTrace activityTrace : activityTraces.getActivityTraces()) {
            String activityName = activityTrace.rootTrace.displayName;
            int hashIndex = activityName.indexOf("#");
            if (hashIndex > 0) {
                activityName = activityName.substring(0, hashIndex);
            }
            String activityMetricRoot = "Mobile/Activity/Name/" + activityName;
            boolean foundMetricForActivity = false;
            List<Metric> unScopedMetrics = metrics.getMetrics().getAllUnscoped();
            if (unScopedMetrics != null && unScopedMetrics.size() > 0) {
                for (Metric metric : unScopedMetrics) {
                    if (!metric.getName().startsWith(activityMetricRoot)) continue;
                    foundMetricForActivity = true;
                    break;
                }
            }
            if (foundMetricForActivity) continue;
            Metric activityMetric = new Metric(activityMetricRoot);
            metrics.addMetric(activityMetric);
        }
    }
}

