/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp3;

import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.util.TreeMap;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttp3TransactionStateUtil
extends TransactionStateUtil {
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public static void inspectAndInstrument(TransactionState transactionState, Request request) {
        if (request == null) {
            log.warning("Missing request");
        } else {
            OkHttp3TransactionStateUtil.inspectAndInstrument(transactionState, request.url().toString(), request.method());
        }
    }

    public static Response inspectAndInstrumentResponse(TransactionState transactionState, Response response) {
        String appData = "";
        int statusCode = -1;
        long contentLength = 0L;
        if (response == null) {
            statusCode = 500;
            log.warning("Missing response");
        } else {
            appData = response.header("X-NewRelic-App-Data");
            statusCode = response.code();
            try {
                contentLength = response.body().contentLength();
            }
            catch (Exception e) {
                log.warning("Missing body or content length");
            }
        }
        OkHttp3TransactionStateUtil.inspectAndInstrumentResponse(transactionState, appData, (int)contentLength, statusCode);
        return OkHttp3TransactionStateUtil.addTransactionAndErrorData(transactionState, response);
    }

    private static Response addTransactionAndErrorData(TransactionState transactionState, Response response) {
        TransactionData transactionData = transactionState.end();
        if (transactionData != null) {
            TaskQueue.queue(new HttpTransactionMeasurement(transactionData.getUrl(), transactionData.getHttpMethod(), transactionData.getStatusCode(), transactionData.getErrorCode(), transactionData.getTimestamp(), transactionData.getTime(), transactionData.getBytesSent(), transactionData.getBytesReceived(), transactionData.getAppData()));
            if ((long)transactionState.getStatusCode() >= 400L && response != null) {
                String responseBodyString;
                TreeMap<String, String> params;
                block5: {
                    String contentTypeHeader = response.header("Content-Type");
                    Object contentType = null;
                    params = new TreeMap<String, String>();
                    if (contentTypeHeader != null && contentTypeHeader.length() > 0 && !"".equals(contentTypeHeader)) {
                        params.put("content_type", (String)contentType);
                    }
                    params.put("content_length", transactionState.getBytesReceived() + "");
                    responseBodyString = "";
                    try {
                        responseBodyString = response.peekBody(response.body().contentLength()).string();
                    }
                    catch (Exception e) {
                        if (response.message() == null) break block5;
                        log.warning("Missing response body, using response message");
                        responseBodyString = response.message();
                    }
                }
                Measurements.addHttpError(transactionData.getUrl(), transactionData.getHttpMethod(), transactionData.getStatusCode(), transactionData.getErrorCode(), responseBodyString, params);
            }
        }
        return response;
    }
}

