/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.crash;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.crash.Crash;
import com.newrelic.agent.android.crash.CrashSender;
import com.newrelic.agent.android.crash.CrashStore;
import com.newrelic.agent.android.crash.UncaughtExceptionHandler;
import com.newrelic.agent.android.payload.PayloadController;
import com.newrelic.agent.android.payload.PayloadReporter;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class CrashReporter
extends PayloadReporter {
    protected static AtomicReference<CrashReporter> instance = new AtomicReference<Object>(null);
    private static boolean reportCrashes = false;
    private final UncaughtExceptionHandler uncaughtExceptionHandler = new UncaughtExceptionHandler(this);
    protected final CrashStore crashStore;

    public static CrashReporter getInstance() {
        return instance.get();
    }

    public static CrashReporter initialize(AgentConfiguration agentConfiguration) {
        instance.compareAndSet(null, new CrashReporter(agentConfiguration));
        return instance.get();
    }

    public static void shutdown() {
        if (CrashReporter.isInitialized()) {
            instance.get().stop();
            instance.set(null);
        }
    }

    public static void setReportCrashes(boolean reportCrashes) {
        if (CrashReporter.isInitialized()) {
            instance.get();
            CrashReporter.reportCrashes = reportCrashes;
        }
    }

    public static UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (CrashReporter.isInitialized()) {
            return CrashReporter.instance.get().uncaughtExceptionHandler;
        }
        return null;
    }

    protected static boolean isInitialized() {
        return instance.get() != null;
    }

    protected CrashReporter(AgentConfiguration agentConfiguration) {
        super(agentConfiguration);
        this.crashStore = agentConfiguration.getCrashStore();
        this.isEnabled.set(agentConfiguration.getReportCrashes());
    }

    @Override
    public void start() {
        if (CrashReporter.isInitialized()) {
            if (this.isEnabled() && this.isStarted.compareAndSet(false, true)) {
                PayloadController.submitCallable(new Callable(){

                    public Void call() {
                        CrashReporter.this.reportSavedCrashes();
                        CrashReporter.this.reportSupportabilityMetrics();
                        return null;
                    }
                });
                this.uncaughtExceptionHandler.installExceptionHandler();
                reportCrashes = this.agentConfiguration.getReportCrashes();
            }
        } else {
            log.error("AgentDataReporter.start(): Must initialize PayloadController first.");
        }
    }

    @Override
    protected void stop() {
    }

    protected void reportSavedCrashes() {
        if (this.crashStore != null) {
            for (Crash crash : this.crashStore.fetchAll()) {
                if (crash.isStale()) {
                    this.crashStore.delete(crash);
                    log.info("Crash [" + crash.getUuid().toString() + "] has become stale, and has been removed");
                    StatsEngine.get().inc("Supportability/AgentHealth/Crash/Removed/Stale");
                    continue;
                }
                this.reportCrash(crash);
            }
        }
    }

    protected Future reportCrash(final Crash crash) {
        if (reportCrashes) {
            if (crash != null) {
                CrashSender sender = new CrashSender(crash, this.agentConfiguration);
                return PayloadController.submitPayload(sender, new PayloadSender.CompletionHandler(){

                    @Override
                    public void onResponse(PayloadSender payloadSender) {
                        if (payloadSender.isSuccessfulResponse() && CrashReporter.this.crashStore != null) {
                            CrashReporter.this.crashStore.delete(crash);
                        }
                    }

                    @Override
                    public void onException(PayloadSender payloadSender, Exception e) {
                        log.error("Crash upload failed: " + e);
                    }
                });
            }
        } else {
            log.warning("CrashReporter.reportCrash(Crash): attempted to report null crash.");
        }
        return null;
    }

    protected void storeAndReportCrash(Crash crash) {
        if (this.crashStore != null) {
            if (crash != null) {
                boolean stored = this.crashStore.store(crash);
                if (!stored) {
                    log.warning("CrashReporter.storeAndReportCrash(Crash): failed to store passed crash.");
                }
            } else {
                log.warning("CrashReporter.storeAndReportCrash(Crash): attempted to store null crash.");
            }
        } else {
            log.warning("CrashReporter.storeAndReportCrash(Crash): attempted to store crash without a crash store.");
        }
        this.reportCrash(crash);
    }
}

